/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.cloud.brigadier.permission;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import me.m56738.easyarmorstands.lib.cloud.SenderMapper;
import me.m56738.easyarmorstands.lib.cloud.brigadier.permission.BrigadierPermissionChecker;
import me.m56738.easyarmorstands.lib.cloud.internal.CommandNode;
import me.m56738.easyarmorstands.lib.cloud.permission.Permission;
import me.m56738.easyarmorstands.lib.geantyref.GenericTypeReflector;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL, since="2.0.0")
public final class BrigadierPermissionPredicate<C, S>
implements Predicate<S> {
    private final SenderMapper<S, C> senderMapper;
    private final BrigadierPermissionChecker<C> permissionChecker;
    private final CommandNode<?> node;

    public BrigadierPermissionPredicate(@NonNull SenderMapper<S, C> senderMapper, @NonNull BrigadierPermissionChecker<C> permissionChecker, @NonNull CommandNode<?> node) {
        this.senderMapper = senderMapper;
        this.permissionChecker = permissionChecker;
        this.node = node;
    }

    @Override
    public boolean test(@NonNull S source) {
        C cloudSender = this.senderMapper.map(source);
        Map accessMap = this.node.nodeMeta().getOrDefault(CommandNode.META_KEY_ACCESS, Collections.emptyMap());
        for (Map.Entry entry : accessMap.entrySet()) {
            if (!GenericTypeReflector.isSuperType((Type)entry.getKey(), cloudSender.getClass()) || !this.permissionChecker.hasPermission(cloudSender, (Permission)entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

