/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lands;

import java.util.Locale;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.enums.FlagTarget;
import me.angeschossen.lands.api.flags.enums.RoleFlagCategory;
import me.angeschossen.lands.api.flags.type.Flags;
import me.angeschossen.lands.api.flags.type.RoleFlag;
import me.angeschossen.lands.api.role.Role;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.addon.Addon;
import me.m56738.easyarmorstands.api.region.RegionPrivilegeChecker;
import me.m56738.easyarmorstands.config.integration.lands.LandsFlagConfig;
import me.m56738.easyarmorstands.lands.LandsPrivilegeChecker;
import org.bukkit.plugin.Plugin;

public class LandsAddon
implements Addon {
    private static final String FLAG_NAME = "easyarmorstands_edit";
    private final EasyArmorStandsPlugin plugin = EasyArmorStandsPlugin.getInstance();
    private final LandsIntegration integration = LandsIntegration.of((Plugin)this.plugin);
    private RegionPrivilegeChecker privilegeChecker;
    private RoleFlag flag;

    public LandsAddon() {
        this.integration.onLoad(this::onLoad);
    }

    private static boolean hasSimilarFlag(Role role) {
        return role != null && role.hasFlag(Flags.BLOCK_PLACE);
    }

    private void onLoad() {
        this.flag = RoleFlag.of((LandsIntegration)this.integration, (FlagTarget)FlagTarget.PLAYER, (RoleFlagCategory)RoleFlagCategory.ACTION, (String)FLAG_NAME);
        this.configureFlag();
    }

    private void configureFlag() {
        LandsFlagConfig flagConfig = this.plugin.getConfiguration().integration.lands.flag;
        this.flag.setIcon(flagConfig.icon.render(Locale.US));
        this.flag.setDisplayName(flagConfig.displayName);
        this.flag.setDescription(flagConfig.description);
        this.flag.setDisplay(flagConfig.display);
        this.flag.setUpdatePredicate(LandsAddon::hasSimilarFlag);
    }

    @Override
    public String name() {
        return "Lands";
    }

    @Override
    public void enable() {
        this.privilegeChecker = new LandsPrivilegeChecker(this.integration, this.flag);
        this.plugin.regionPrivilegeManager().registerPrivilegeChecker((Plugin)this.plugin, this.privilegeChecker);
    }

    @Override
    public void disable() {
        this.plugin.regionPrivilegeManager().unregisterPrivilegeChecker(this.privilegeChecker);
    }

    @Override
    public void reload() {
        if (this.flag != null) {
            this.configureFlag();
        }
    }
}

