/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.util.ItemTemplate;
import me.m56738.easyarmorstands.capability.component.ComponentCapability;
import me.m56738.easyarmorstands.item.ItemRenderer;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SimpleItemTemplate
implements ItemTemplate {
    private final ItemStack template;
    private final String displayName;
    private final List<String> lore;
    private final TagResolver resolver;
    private final ItemRenderer renderer;

    public SimpleItemTemplate(ItemStack template, String displayName, List<String> lore, TagResolver resolver, ItemRenderer renderer) {
        this.template = template.clone();
        this.displayName = displayName;
        this.lore = Collections.unmodifiableList(new ArrayList<String>(lore));
        this.resolver = resolver;
        this.renderer = renderer;
    }

    private Component renderName(Locale locale, TagResolver resolver) {
        return this.renderer.renderName(this.displayName, locale, resolver);
    }

    private List<Component> renderLore(Locale locale, TagResolver resolver) {
        ArrayList<Component> renderedLore = new ArrayList<Component>(this.lore.size());
        for (String line : this.lore) {
            renderedLore.add(this.renderer.renderLore(line, locale, resolver));
        }
        return renderedLore;
    }

    @Override
    public ItemStack render(Locale locale) {
        return this.render(locale, TagResolver.empty());
    }

    @Override
    public ItemStack render(Locale locale, TagResolver resolver) {
        resolver = TagResolver.builder().resolver(this.resolver).resolver(resolver).build();
        ComponentCapability componentCapability = EasyArmorStandsPlugin.getInstance().getCapability(ComponentCapability.class);
        ItemStack item = this.template.clone();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (this.displayName != null) {
                componentCapability.setDisplayName(meta, this.renderName(locale, resolver));
            }
            componentCapability.setLore(meta, this.renderLore(locale, resolver));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            item.setItemMeta(meta);
        }
        return item;
    }

    public SimpleItemTemplate appendLore(List<String> lore) {
        ArrayList<String> newLore = new ArrayList<String>(this.lore.size() + lore.size());
        newLore.addAll(this.lore);
        newLore.addAll(lore);
        return new SimpleItemTemplate(this.template, this.displayName, newLore, this.resolver, this.renderer);
    }

    public SimpleItemTemplate editMeta(Consumer<ItemMeta> consumer) {
        ItemStack newTemplate = this.template.clone();
        ItemMeta meta = newTemplate.getItemMeta();
        if (meta != null) {
            consumer.accept(meta);
            newTemplate.setItemMeta(meta);
        }
        return new SimpleItemTemplate(newTemplate, this.displayName, this.lore, this.resolver, this.renderer);
    }

    public SimpleItemTemplate addResolver(TagResolver resolver) {
        return new SimpleItemTemplate(this.template, this.displayName, this.lore, TagResolver.resolver(this.resolver, resolver), this.renderer);
    }

    public SimpleItemTemplate withTemplate(ItemStack template) {
        return new SimpleItemTemplate(template, this.displayName, this.lore, this.resolver, this.renderer);
    }

    public SimpleItemTemplate withFallbackTemplate(ItemStack template) {
        if (this.template.getType() != Material.AIR && this.template.getAmount() != 0) {
            return this;
        }
        return this.withTemplate(template);
    }

    public SimpleItemTemplate withRenderer(ItemRenderer renderer) {
        return new SimpleItemTemplate(this.template, this.displayName, this.lore, this.resolver, renderer);
    }

    public Material getType() {
        return this.template.getType();
    }
}

