/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.history;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.m56738.easyarmorstands.history.History;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public class HistoryManager
implements Listener {
    private final Map<Player, History> history = new HashMap<Player, History>();

    public History getHistory(Player player) {
        if (!player.isOnline()) {
            return new History();
        }
        return this.history.computeIfAbsent(player, p -> new History());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.history.remove(event.getPlayer());
    }

    public void onEntityReplaced(@NotNull UUID oldId, @NotNull UUID newId) {
        for (History history : this.history.values()) {
            history.onEntityReplaced(oldId, newId);
        }
    }
}

