/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.group.tool;

import java.util.ArrayList;
import java.util.List;
import me.m56738.easyarmorstands.api.editor.tool.Tool;
import me.m56738.easyarmorstands.api.editor.tool.ToolSession;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public abstract class GroupToolSession<S extends ToolSession>
implements ToolSession {
    protected final List<S> sessions;

    protected GroupToolSession(List<? extends Tool<S>> tools) {
        this.sessions = new ArrayList<S>(tools.size());
        for (Tool<S> tool : tools) {
            this.sessions.add(tool.start());
        }
    }

    @Override
    public void revert() {
        for (ToolSession session : this.sessions) {
            session.revert();
        }
    }

    @Override
    public void commit(@Nullable Component description) {
        for (ToolSession session : this.sessions) {
            session.commit(description);
        }
    }

    @Override
    public boolean isValid() {
        for (ToolSession session : this.sessions) {
            if (!session.isValid()) continue;
            return true;
        }
        return false;
    }
}

