/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.group.tool;

import java.util.ArrayList;
import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.tool.AxisMoveTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateTool;
import me.m56738.easyarmorstands.api.editor.tool.MoveTool;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.api.editor.tool.ToolProvider;
import me.m56738.easyarmorstands.api.util.PositionProvider;
import me.m56738.easyarmorstands.api.util.RotationProvider;
import me.m56738.easyarmorstands.group.Group;
import me.m56738.easyarmorstands.group.GroupMember;
import me.m56738.easyarmorstands.group.GroupPositionProvider;
import me.m56738.easyarmorstands.group.tool.GroupAxisMoveTool;
import me.m56738.easyarmorstands.group.tool.GroupAxisRotateTool;
import me.m56738.easyarmorstands.group.tool.GroupMoveTool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupToolProvider
implements ToolProvider {
    private final Group group;
    private final PositionProvider positionProvider;

    public GroupToolProvider(Group group) {
        this.group = group;
        this.positionProvider = new GroupPositionProvider(group);
    }

    @Override
    @NotNull
    public PositionProvider position() {
        return this.positionProvider;
    }

    @Override
    @NotNull
    public RotationProvider rotation() {
        return RotationProvider.identity();
    }

    @Override
    @Nullable
    public MoveTool move(@NotNull ToolContext context) {
        ArrayList<MoveTool> tools = new ArrayList<MoveTool>();
        for (GroupMember member : this.group.getMembers()) {
            MoveTool tool = member.getTools().move(context);
            if (tool == null) {
                return ToolProvider.super.move(context);
            }
            tools.add(tool);
        }
        return new GroupMoveTool(context, tools);
    }

    @Override
    @Nullable
    public AxisMoveTool move(@NotNull ToolContext context, @NotNull Axis axis) {
        ArrayList<AxisMoveTool> tools = new ArrayList<AxisMoveTool>();
        for (GroupMember member : this.group.getMembers()) {
            AxisMoveTool tool = member.getTools().move(context, axis);
            if (tool == null) {
                return ToolProvider.super.move(context, axis);
            }
            tools.add(tool);
        }
        return new GroupAxisMoveTool(context, axis, tools);
    }

    @Override
    @Nullable
    public AxisRotateTool rotate(@NotNull ToolContext context, @NotNull Axis axis) {
        ArrayList<AxisRotateTool> tools = new ArrayList<AxisRotateTool>();
        for (GroupMember member : this.group.getMembers()) {
            AxisRotateTool tool = member.getTools().rotate(context, axis);
            if (tool == null) {
                return ToolProvider.super.rotate(context, axis);
            }
            tools.add(tool);
        }
        return new GroupAxisRotateTool(context, axis, tools);
    }
}

