/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.fancyholograms.element;

import de.oliver.fancyholograms.api.HologramManager;
import de.oliver.fancyholograms.api.data.BlockHologramData;
import de.oliver.fancyholograms.api.data.DisplayHologramData;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.ItemHologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.hologram.Hologram;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.element.ElementType;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.fancyholograms.FancyHologramsAddon;
import me.m56738.easyarmorstands.fancyholograms.element.HologramElement;
import me.m56738.easyarmorstands.fancyholograms.property.HologramDataProperty;
import me.m56738.easyarmorstands.fancyholograms.property.HologramLocationProperty;
import me.m56738.easyarmorstands.fancyholograms.property.block.BlockHologramBlockProperty;
import me.m56738.easyarmorstands.fancyholograms.property.display.DisplayHologramBillboardProperty;
import me.m56738.easyarmorstands.fancyholograms.property.display.DisplayHologramScaleProperty;
import me.m56738.easyarmorstands.fancyholograms.property.item.ItemHologramItemProperty;
import me.m56738.easyarmorstands.fancyholograms.property.text.TextHologramAlignmentProperty;
import me.m56738.easyarmorstands.fancyholograms.property.text.TextHologramBackgroundProperty;
import me.m56738.easyarmorstands.fancyholograms.property.text.TextHologramSeeThroughProperty;
import me.m56738.easyarmorstands.fancyholograms.property.text.TextHologramShadowProperty;
import me.m56738.easyarmorstands.fancyholograms.property.text.TextHologramTextProperty;
import me.m56738.easyarmorstands.fancyholograms.property.type.HologramDataPropertyType;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.util.JOMLMapper;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HologramElementType
implements ElementType {
    private final HologramManager manager;
    private final JOMLMapper mapper;
    private final FancyHologramsAddon addon;

    public HologramElementType(HologramManager manager, JOMLMapper mapper, FancyHologramsAddon addon) {
        this.manager = manager;
        this.mapper = mapper;
        this.addon = addon;
    }

    public HologramElement getElement(Hologram hologram) {
        HologramElement element = new HologramElement(this, this.manager, hologram, this.addon);
        HologramData data = hologram.getData();
        element.getProperties().register(new HologramDataProperty(hologram));
        element.getProperties().register(new HologramLocationProperty(hologram));
        if (data instanceof DisplayHologramData) {
            DisplayHologramData displayData = (DisplayHologramData)data;
            element.getProperties().register(new DisplayHologramScaleProperty(hologram, displayData, this.mapper));
            element.getProperties().register(new DisplayHologramBillboardProperty(hologram, displayData));
        }
        if (data instanceof ItemHologramData) {
            ItemHologramData itemData = (ItemHologramData)data;
            element.getProperties().register(new ItemHologramItemProperty(hologram, itemData));
        }
        if (data instanceof BlockHologramData) {
            BlockHologramData blockData = (BlockHologramData)data;
            element.getProperties().register(new BlockHologramBlockProperty(hologram, blockData));
        }
        if (data instanceof TextHologramData) {
            TextHologramData textData = (TextHologramData)data;
            element.getProperties().register(new TextHologramTextProperty(hologram, textData));
            element.getProperties().register(new TextHologramShadowProperty(hologram, textData));
            element.getProperties().register(new TextHologramSeeThroughProperty(hologram, textData));
            element.getProperties().register(new TextHologramAlignmentProperty(hologram, textData));
            element.getProperties().register(new TextHologramBackgroundProperty(hologram, textData));
        }
        return element;
    }

    @Override
    public boolean canSpawn(@NotNull Player player) {
        return player.hasPermission("easyarmorstands.fancyholograms.spawn");
    }

    @Override
    @Nullable
    public Element createElement(@NotNull PropertyContainer properties) {
        Property<HologramData> property = properties.getOrNull(HologramDataPropertyType.INSTANCE);
        if (property == null) {
            return null;
        }
        HologramData data = property.getValue();
        if (this.manager.getHologram(data.getName()).isPresent()) {
            return null;
        }
        Hologram hologram = this.manager.create(data);
        this.manager.addHologram(hologram);
        return this.getElement(hologram);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.text("Hologram");
    }
}

