/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.element;

import java.util.function.Consumer;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.element.EntityElementType;
import me.m56738.easyarmorstands.api.event.element.EntityElementInitializeEvent;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.capability.entitytype.EntityTypeCapability;
import me.m56738.easyarmorstands.capability.spawn.SpawnCapability;
import me.m56738.easyarmorstands.element.SimpleEntityElement;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.permission.Permissions;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleEntityElementType<E extends Entity>
implements EntityElementType<E> {
    private final EntityType entityType;
    private final Class<E> entityClass;
    private final Component displayName;

    public SimpleEntityElementType(EntityType entityType, Class<E> entityClass) {
        EntityTypeCapability entityTypeCapability = EasyArmorStandsPlugin.getInstance().getCapability(EntityTypeCapability.class);
        this.entityType = entityType;
        this.entityClass = entityClass;
        this.displayName = entityTypeCapability.getName(entityType);
    }

    @Override
    @NotNull
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    @NotNull
    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    protected SimpleEntityElement<E> createInstance(E entity) {
        return new SimpleEntityElement<E>(entity, this);
    }

    @Override
    public SimpleEntityElement<E> getElement(@NotNull E entity) {
        SimpleEntityElement<E> element = this.createInstance(entity);
        Bukkit.getPluginManager().callEvent((Event)new EntityElementInitializeEvent(element));
        return element;
    }

    @Override
    @Nullable
    public SimpleEntityElement<E> createElement(@NotNull PropertyContainer properties) {
        Property<Location> locationProperty = properties.getOrNull(EntityPropertyTypes.LOCATION);
        if (locationProperty == null) {
            return null;
        }
        Location location = locationProperty.getValue();
        SpawnedEntityConfigurator configurator = new SpawnedEntityConfigurator(properties);
        E entity = EasyArmorStandsPlugin.getInstance().getCapability(SpawnCapability.class).spawnEntity(location, this.entityClass, configurator);
        if (entity == null) {
            return null;
        }
        SimpleEntityElement element = configurator.getElement();
        if (element != null) {
            entity.teleport(location);
        } else {
            entity.remove();
        }
        return element;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean canSpawn(@NotNull Player player) {
        return player.hasPermission(Permissions.entityType("easyarmorstands.spawn", this.entityType));
    }

    private class SpawnedEntityConfigurator
    implements Consumer<E> {
        private final PropertyContainer properties;
        private SimpleEntityElement<E> element;

        private SpawnedEntityConfigurator(PropertyContainer properties) {
            this.properties = properties;
        }

        @Override
        public void accept(E entity) {
            this.element = SimpleEntityElementType.this.getElement((Entity)entity);
            if (this.element != null) {
                this.copyProperties(this.properties, this.element.getProperties());
            }
        }

        private void copyProperties(PropertyContainer source, PropertyContainer target) {
            source.forEach(p -> this.copyProperty((Property)p, target));
        }

        private <T> void copyProperty(Property<T> sourceProperty, PropertyContainer target) {
            PropertyType<T> type = sourceProperty.getType();
            if (type == EntityPropertyTypes.LOCATION) {
                return;
            }
            Property<T> targetProperty = target.getOrNull(type);
            if (targetProperty != null) {
                targetProperty.setValue(sourceProperty.getValue());
            }
        }

        @Nullable
        public SimpleEntityElement<E> getElement() {
            return this.element;
        }
    }
}

