/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.element;

import me.m56738.easyarmorstands.api.ArmorStandSize;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.BoundingBoxButton;
import me.m56738.easyarmorstands.api.editor.button.Button;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.editor.tool.ToolProvider;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.PropertyRegistry;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.editor.EntityPositionProvider;
import me.m56738.easyarmorstands.editor.armorstand.ArmorStandOffsetProvider;
import me.m56738.easyarmorstands.editor.armorstand.ArmorStandRotationProvider;
import me.m56738.easyarmorstands.editor.armorstand.node.ArmorStandRootNode;
import me.m56738.easyarmorstands.element.ArmorStandToolProvider;
import me.m56738.easyarmorstands.element.SimpleEntityElement;
import me.m56738.easyarmorstands.element.SimpleEntityElementType;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.entity.ArmorStand;
import org.jetbrains.annotations.NotNull;

public class ArmorStandElement
extends SimpleEntityElement<ArmorStand> {
    private final ArmorStand entity;

    public ArmorStandElement(ArmorStand entity, SimpleEntityElementType<ArmorStand> type) {
        super(entity, type);
        this.entity = entity;
    }

    @Override
    @NotNull
    public Button createButton(@NotNull Session session) {
        PropertyRegistry properties = this.getProperties();
        return new BoundingBoxButton(session, this, new EntityPositionProvider(properties, new ArmorStandOffsetProvider(this, properties)), new ArmorStandRotationProvider(properties));
    }

    @Override
    @NotNull
    public Node createNode(@NotNull Session session) {
        return new ArmorStandRootNode(session, this.entity, this);
    }

    @Override
    @NotNull
    public ToolProvider getTools(@NotNull PropertyContainer properties) {
        return new ArmorStandToolProvider(properties);
    }

    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        ArmorStandSize size = ArmorStandSize.get(this.entity);
        Vector3d position = Util.toVector3d(this.entity.getLocation());
        double scale = this.getScale();
        double width = size.getWidth() * scale;
        double height = size.getHeight() * scale;
        return BoundingBox.of((Vector3dc)position, width, height);
    }
}

