/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.node;

import java.util.function.Consumer;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.element.ElementDiscoveryEntry;
import me.m56738.easyarmorstands.api.element.ElementDiscoverySource;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.editor.node.EntityElementDiscoveryEntry;
import me.m56738.easyarmorstands.element.EntityElementProviderRegistryImpl;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityElementDiscoverySource
implements ElementDiscoverySource {
    private final Player player;
    private final EntityElementProviderRegistryImpl providerRegistry;

    public EntityElementDiscoverySource(@NotNull Player player) {
        this(player, EasyArmorStandsPlugin.getInstance().entityElementProviderRegistry());
    }

    public EntityElementDiscoverySource(@NotNull Player player, @NotNull EntityElementProviderRegistryImpl providerRegistry) {
        this.player = player;
        this.providerRegistry = providerRegistry;
    }

    @NotNull
    public ElementDiscoveryEntry getEntry(@NotNull Entity entity) {
        return new EntityElementDiscoveryEntry(this, this.player, entity);
    }

    @Nullable
    public Element getElement(@NotNull Entity entity) {
        return this.providerRegistry.getElement(entity);
    }

    @Override
    public void discover(@NotNull World world, @NotNull BoundingBox box, @NotNull @NotNull Consumer<@NotNull ElementDiscoveryEntry> consumer) {
        Vector3d delta = box.getMaxPosition().sub(box.getMinPosition(), new Vector3d()).div(2.0);
        Vector3d center = box.getMinPosition().add(delta, new Vector3d());
        Location location = new Location(world, center.x(), center.y(), center.z());
        for (Entity entity : world.getNearbyEntities(location, delta.x(), delta.y(), delta.z())) {
            if (entity.equals((Object)this.player)) continue;
            consumer.accept(this.getEntry(entity));
        }
    }
}

