/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.button;

import java.util.function.Consumer;
import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.EyeRay;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.ButtonResult;
import me.m56738.easyarmorstands.api.editor.tool.AxisTool;
import me.m56738.easyarmorstands.api.particle.LineParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.editor.button.NodeFactoryButton;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public abstract class AxisToolButton
implements NodeFactoryButton {
    private final Session session;
    private final AxisTool<?> tool;
    private final Vector3d position = new Vector3d();
    private final Quaterniond rotation = new Quaterniond();
    private final Vector3d direction = new Vector3d();
    private final Vector3d negativeEnd = new Vector3d();
    private final Vector3d positiveEnd = new Vector3d();
    private final LineParticle particle;
    private final double length;
    private final Component name;
    private final ParticleColor color;
    private double scale;
    private Axis axis;

    public AxisToolButton(Session session, AxisTool<?> tool, double length, Component name, ParticleColor color) {
        this.name = name;
        this.session = session;
        this.tool = tool;
        this.length = length;
        this.particle = session.particleProvider().createLine();
        this.color = color;
    }

    @Override
    public void update() {
        this.position.set(this.tool.getPosition());
        this.rotation.set(this.tool.getRotation());
        this.axis = this.tool.getAxis();
        this.axis.getDirection().rotate(this.rotation, this.direction);
        this.scale = this.session.getScale(this.position);
        this.position.fma(-this.length / 2.0 * this.scale, (Vector3dc)this.direction, this.negativeEnd);
        this.position.fma(this.length / 2.0 * this.scale, (Vector3dc)this.direction, this.positiveEnd);
    }

    @Override
    public void intersect(@NotNull EyeRay ray, @NotNull @NotNull Consumer<@NotNull ButtonResult> results) {
        Vector3dc intersection = ray.intersectLine(this.negativeEnd, this.positiveEnd, this.scale);
        if (intersection != null) {
            results.accept(ButtonResult.of(intersection));
        }
    }

    @Override
    public void updatePreview(boolean focused) {
        this.particle.setCenter(this.position);
        this.particle.setRotation(this.rotation);
        this.particle.setAxis(this.axis);
        this.particle.setColor(focused ? ParticleColor.YELLOW : this.color);
        this.particle.setLength(this.length * this.scale);
        this.particle.setWidth(0.015625 * this.scale);
    }

    @Override
    public void showPreview() {
        this.session.addParticle(this.particle);
    }

    @Override
    public void hidePreview() {
        this.session.removeParticle(this.particle);
    }

    @NotNull
    public Session getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public Component getName() {
        return this.name;
    }

    @NotNull
    public Vector3dc getPosition() {
        return this.position;
    }

    @NotNull
    public Quaterniondc getRotation() {
        return this.rotation;
    }

    @NotNull
    public Axis getAxis() {
        return this.axis;
    }

    @NotNull
    public ParticleColor getColor() {
        return this.color;
    }

    public double getLength() {
        return this.length;
    }
}

