/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.button;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.AxisScaleButton;
import me.m56738.easyarmorstands.api.editor.button.AxisScaleButtonBuilder;
import me.m56738.easyarmorstands.api.editor.tool.AxisScaleTool;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.editor.button.AxisScaleButtonImpl;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.message.Message;
import org.jetbrains.annotations.NotNull;

public class AxisScaleButtonBuilderImpl
implements AxisScaleButtonBuilder {
    private final Session session;
    private AxisScaleTool tool;
    private double length = 3.0;
    private Component name;
    private ParticleColor color;

    public AxisScaleButtonBuilderImpl(Session session) {
        this.session = session;
    }

    @Override
    @NotNull
    public AxisScaleButtonBuilder setTool(@NotNull AxisScaleTool tool) {
        this.tool = tool;
        return this;
    }

    @Override
    @NotNull
    public AxisScaleButtonBuilder setLength(double length) {
        this.length = length;
        return this;
    }

    @Override
    @NotNull
    public AxisScaleButtonBuilder setName(@NotNull Component name) {
        this.name = name;
        return this;
    }

    @Override
    @NotNull
    public AxisScaleButtonBuilder setColor(@NotNull ParticleColor color) {
        this.color = color;
        return this;
    }

    @Override
    @NotNull
    public AxisScaleButton build() {
        ParticleColor color;
        if (this.tool == null) {
            throw new IllegalStateException("Tool not set");
        }
        Axis axis = this.tool.getAxis();
        Component name = this.name;
        if (name == null) {
            TextColor textColor = TextColor.color(axis.getColor());
            name = Message.component("easyarmorstands.node.scale-along-axis", Component.text(axis.getName())).color(textColor);
        }
        if ((color = this.color) == null) {
            color = axis.getColor();
        }
        return new AxisScaleButtonImpl(this.session, this.tool, this.length, name, color);
    }
}

