/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.button;

import java.util.function.Consumer;
import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.EyeRay;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.AxisRotateButton;
import me.m56738.easyarmorstands.api.editor.button.ButtonResult;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateToolSession;
import me.m56738.easyarmorstands.api.particle.CircleParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.editor.button.NodeFactoryButton;
import me.m56738.easyarmorstands.editor.node.AxisRotateToolNode;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class AxisRotateButtonImpl
implements NodeFactoryButton,
AxisRotateButton {
    private final Session session;
    private final AxisRotateTool tool;
    private final Vector3d position = new Vector3d();
    private final Quaterniond rotation = new Quaterniond();
    private final Vector3d direction = new Vector3d();
    private final CircleParticle particle;
    private final double radius;
    private final double length;
    private final Component name;
    private final ParticleColor color;
    private double scale;
    private Axis axis;

    public AxisRotateButtonImpl(Session session, AxisRotateTool tool, double radius, double length, Component name, ParticleColor color) {
        this.session = session;
        this.tool = tool;
        this.particle = session.particleProvider().createCircle();
        this.radius = radius;
        this.length = length;
        this.name = name;
        this.color = color;
    }

    @Override
    public void update() {
        this.position.set(this.tool.getPosition());
        this.rotation.set(this.tool.getRotation());
        this.scale = this.session.getScale(this.position);
        this.axis = this.tool.getAxis();
        this.axis.getDirection().rotate(this.rotation, this.direction);
    }

    @Override
    public void intersect(@NotNull EyeRay ray, @NotNull @NotNull Consumer<@NotNull ButtonResult> results) {
        Vector3dc intersection = ray.intersectCircle(this.position, this.direction, this.radius * this.scale, this.scale);
        if (intersection != null) {
            results.accept(ButtonResult.of(intersection));
        }
    }

    @Override
    public void updatePreview(boolean focused) {
        this.particle.setCenter(this.position);
        this.particle.setRotation(this.rotation);
        this.particle.setAxis(this.axis);
        this.particle.setColor(focused ? ParticleColor.YELLOW : this.color);
        this.particle.setRadius(this.radius * this.scale);
        this.particle.setWidth(0.015625 * this.scale);
    }

    @Override
    public void showPreview() {
        this.session.addParticle(this.particle);
    }

    @Override
    public void hidePreview() {
        this.session.removeParticle(this.particle);
    }

    @Override
    @NotNull
    public Component getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Node createNode() {
        return new AxisRotateToolNode(this.session, (AxisRotateToolSession)this.tool.start(), this.radius, this.length, this.name, this.color, this.position, this.rotation, this.axis);
    }
}

