/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.button;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.AxisMoveButton;
import me.m56738.easyarmorstands.api.editor.button.AxisMoveButtonBuilder;
import me.m56738.easyarmorstands.api.editor.tool.AxisMoveTool;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.editor.button.AxisMoveButtonImpl;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.message.Message;
import org.jetbrains.annotations.NotNull;

public class AxisMoveButtonBuilderImpl
implements AxisMoveButtonBuilder {
    private final Session session;
    private AxisMoveTool tool;
    private double length = 3.0;
    private Component name;
    private ParticleColor color;

    public AxisMoveButtonBuilderImpl(Session session) {
        this.session = session;
    }

    @Override
    @NotNull
    public AxisMoveButtonBuilder setTool(@NotNull AxisMoveTool tool) {
        this.tool = tool;
        return this;
    }

    @Override
    @NotNull
    public AxisMoveButtonBuilder setLength(double length) {
        this.length = length;
        return this;
    }

    @Override
    @NotNull
    public AxisMoveButtonBuilder setName(@NotNull Component name) {
        this.name = name;
        return this;
    }

    @Override
    @NotNull
    public AxisMoveButtonBuilder setColor(@NotNull ParticleColor color) {
        this.color = color;
        return this;
    }

    @Override
    @NotNull
    public AxisMoveButton build() {
        ParticleColor color;
        if (this.tool == null) {
            throw new IllegalStateException("Tool not set");
        }
        Axis axis = this.tool.getAxis();
        Component name = this.name;
        if (name == null) {
            TextColor textColor = TextColor.color(axis.getColor());
            name = Message.component("easyarmorstands.node.move-along-axis", Component.text(axis.getName())).color(textColor);
        }
        if ((color = this.color) == null) {
            color = axis.getColor();
        }
        return new AxisMoveButtonImpl(this.session, this.tool, this.length, name, color);
    }
}

