/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.display.property.display.text;

import java.util.Optional;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.display.api.property.type.TextDisplayPropertyTypes;
import org.bukkit.Color;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.NotNull;

public class TextDisplayBackgroundProperty
implements Property<Optional<Color>> {
    private static final int DEFAULT_COLOR = 0x40000000;
    private final TextDisplay entity;

    public TextDisplayBackgroundProperty(TextDisplay entity) {
        this.entity = entity;
    }

    public static boolean isSupported() {
        try {
            TextDisplay.class.getMethod("getBackgroundColor", new Class[0]);
            TextDisplay.class.getMethod("setBackgroundColor", Color.class);
            TextDisplay.class.getMethod("isDefaultBackground", new Class[0]);
            TextDisplay.class.getMethod("setDefaultBackground", Boolean.TYPE);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    @NotNull
    public PropertyType<Optional<Color>> getType() {
        return TextDisplayPropertyTypes.BACKGROUND;
    }

    @Override
    @NotNull
    public Optional<Color> getValue() {
        if (this.entity.isDefaultBackground()) {
            return Optional.empty();
        }
        Color color = this.entity.getBackgroundColor();
        if (color == null) {
            color = Color.WHITE;
        } else if (color.asARGB() == 0x40000000) {
            return Optional.empty();
        }
        return Optional.of(color);
    }

    @Override
    public boolean setValue(@NotNull Optional<Color> value) {
        this.entity.setDefaultBackground(!value.isPresent());
        this.entity.setBackgroundColor((Color)value.orElse(null));
        return true;
    }
}

