/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.display.adapter;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import me.m56738.easyarmorstands.display.adapter.TextDisplayAdapter;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.util.NativeComponentMapper;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.Nullable;

public class PaperTextDisplayAdapter
extends TextDisplayAdapter {
    private static final PaperTextDisplayAdapter instance = PaperTextDisplayAdapter.initialize();
    private final NativeComponentMapper mapper;
    private final MethodHandle getText;
    private final MethodHandle setText;

    private PaperTextDisplayAdapter(NativeComponentMapper mapper, MethodHandle getText, MethodHandle setText) {
        this.mapper = mapper;
        this.getText = getText;
        this.setText = setText;
    }

    @Nullable
    public static PaperTextDisplayAdapter getInstance() {
        return instance;
    }

    private static PaperTextDisplayAdapter initialize() {
        try {
            NativeComponentMapper mapper = NativeComponentMapper.getInstance();
            if (mapper == null) {
                return null;
            }
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle getText = lookup.findVirtual(TextDisplay.class, "text", MethodType.methodType(mapper.getComponentClass()));
            MethodHandle setText = lookup.findVirtual(TextDisplay.class, "text", MethodType.methodType(Void.TYPE, mapper.getComponentClass()));
            return new PaperTextDisplayAdapter(mapper, getText, setText);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    @Override
    public Component getText(TextDisplay entity) {
        try {
            return this.mapper.convertFromNative(this.getText.invoke(entity));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setText(TextDisplay entity, Component text) {
        try {
            this.setText.invoke(entity, this.mapper.convertToNative(text));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

