/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.command.value;

import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.command.processor.PropertyPermissionPredicate;
import me.m56738.easyarmorstands.command.sender.EasCommandSender;
import me.m56738.easyarmorstands.command.value.ValueCommand;
import me.m56738.easyarmorstands.lib.cloud.parser.ParserDescriptor;
import me.m56738.easyarmorstands.lib.cloud.permission.Permission;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public abstract class PropertyCommand<T>
implements ValueCommand<T> {
    private final PropertyType<T> type;
    private final ParserDescriptor<EasCommandSender, T> parser;

    public PropertyCommand(PropertyType<T> type, ParserDescriptor<EasCommandSender, T> parser) {
        this.type = type;
        this.parser = parser;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return this.type.getName();
    }

    @Override
    @NotNull
    public Permission getPermission() {
        return PropertyPermissionPredicate.createPermission(this.type);
    }

    @Override
    @NotNull
    public ParserDescriptor<EasCommandSender, T> getParser() {
        return this.parser;
    }

    @Override
    public boolean isSupported(@NotNull PropertyContainer properties) {
        return properties.getOrNull(this.type) != null;
    }

    @Override
    @NotNull
    public T getValue(@NotNull PropertyContainer properties) {
        return properties.get(this.type).getValue();
    }

    @Override
    public boolean setValue(@NotNull PropertyContainer properties, @NotNull T value) {
        return properties.get(this.type).setValue(value);
    }

    @Override
    @NotNull
    public Component formatValue(@NotNull T value) {
        return this.type.getValueComponent(value);
    }
}

