/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.command.value;

import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.command.sender.EasCommandSender;
import me.m56738.easyarmorstands.command.value.PropertyCommand;
import me.m56738.easyarmorstands.lib.cloud.bukkit.parser.location.LocationParser;
import me.m56738.easyarmorstands.lib.cloud.description.Description;
import me.m56738.easyarmorstands.lib.cloud.minecraft.extras.RichDescription;
import me.m56738.easyarmorstands.lib.cloud.permission.Permission;
import me.m56738.easyarmorstands.lib.kyori.adventure.audience.Audience;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.Location;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public class PositionCommand
extends PropertyCommand<Location> {
    public PositionCommand() {
        super(EntityPropertyTypes.LOCATION, LocationParser.locationParser());
    }

    @Override
    public  @NonNull Command.Builder<EasCommandSender> applyToCommandBuilder( @NonNull Command.Builder<EasCommandSender> builder) {
        return builder.literal("position", new String[0]);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Message.component("easyarmorstands.command.value.position");
    }

    @Override
    @NotNull
    public Permission getPermission() {
        return Permission.allOf(super.getPermission(), Permission.of("easyarmorstands.position"));
    }

    @Override
    @NotNull
    public Description getShowDescription() {
        return RichDescription.translatable("easyarmorstands.command.description.position.show");
    }

    @Override
    @NotNull
    public Description getSetterDescription() {
        return RichDescription.translatable("easyarmorstands.command.description.position.set");
    }

    @Override
    @NotNull
    public String formatCommand(@NotNull Location value) {
        return "/eas position " + value.getX() + " " + value.getY() + " " + value.getZ();
    }

    @Override
    public boolean setValue(@NotNull PropertyContainer properties, @NotNull Location value) {
        Property<Location> property = properties.get(EntityPropertyTypes.LOCATION);
        Location location = property.getValue();
        location.setX(value.getX());
        location.setY(value.getY());
        location.setZ(value.getZ());
        return property.setValue(location);
    }

    @Override
    public void sendSuccess(@NotNull Audience audience, @NotNull Location value) {
        audience.sendMessage(Message.success("easyarmorstands.success.moved", Util.formatLocation(value)));
    }
}

