/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.command.value;

import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.command.processor.PropertyPermissionPredicate;
import me.m56738.easyarmorstands.command.sender.EasCommandSender;
import me.m56738.easyarmorstands.command.value.ValueCommand;
import me.m56738.easyarmorstands.lib.cloud.description.Description;
import me.m56738.easyarmorstands.lib.cloud.minecraft.extras.RichDescription;
import me.m56738.easyarmorstands.lib.cloud.parser.ParserDescriptor;
import me.m56738.easyarmorstands.lib.cloud.parser.standard.FloatParser;
import me.m56738.easyarmorstands.lib.cloud.permission.Permission;
import me.m56738.easyarmorstands.lib.kyori.adventure.audience.Audience;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.Location;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public class PitchCommand
implements ValueCommand<Float> {
    @Override
    public  @NonNull Command.Builder<EasCommandSender> applyToCommandBuilder( @NonNull Command.Builder<EasCommandSender> builder) {
        return builder.literal("pitch", new String[0]);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Message.component("easyarmorstands.command.value.pitch");
    }

    @Override
    @NotNull
    public Permission getPermission() {
        return PropertyPermissionPredicate.createPermission(EntityPropertyTypes.LOCATION);
    }

    @Override
    @NotNull
    public ParserDescriptor<EasCommandSender, Float> getParser() {
        return FloatParser.floatParser();
    }

    @Override
    @NotNull
    public Description getShowDescription() {
        return RichDescription.translatable("easyarmorstands.command.description.pitch.show");
    }

    @Override
    @NotNull
    public Description getSetterDescription() {
        return RichDescription.translatable("easyarmorstands.command.description.pitch.set");
    }

    @Override
    @NotNull
    public Float getValue(@NotNull PropertyContainer properties) {
        return Float.valueOf(properties.get(EntityPropertyTypes.LOCATION).getValue().getPitch());
    }

    @Override
    public boolean setValue(@NotNull PropertyContainer properties, @NotNull Float value) {
        Property<Location> property = properties.get(EntityPropertyTypes.LOCATION);
        Location location = property.getValue();
        location.setPitch(value.floatValue());
        return property.setValue(location);
    }

    @Override
    @NotNull
    public Component formatValue(@NotNull Float value) {
        return Util.formatDegrees(value.floatValue());
    }

    @Override
    @NotNull
    public String formatCommand(@NotNull Float value) {
        return "/eas pitch " + value;
    }

    @Override
    public void sendSuccess(@NotNull Audience audience, @NotNull Float value) {
        audience.sendMessage(Message.success("easyarmorstands.success.changed-pitch", Util.formatDegrees(value.floatValue())));
    }
}

