/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.command.requirement;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import me.m56738.easyarmorstands.command.requirement.CommandRequirement;
import me.m56738.easyarmorstands.command.sender.EasCommandSender;
import me.m56738.easyarmorstands.lib.cloud.Command;
import me.m56738.easyarmorstands.lib.cloud.annotations.BuilderModifier;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CommandRequirementBuilderModifier<A extends Annotation>
implements BuilderModifier<A, EasCommandSender> {
    private final Function<A, CommandRequirement> requirementProvider;

    public CommandRequirementBuilderModifier(Function<A, CommandRequirement> requirementProvider) {
        this.requirementProvider = requirementProvider;
    }

    public static  @NonNull Command.Builder<EasCommandSender> addRequirement( @NonNull Command.Builder<EasCommandSender> builder, @NonNull CommandRequirement requirement) {
        ArrayList<CommandRequirement> requirements = new ArrayList<CommandRequirement>(builder.meta().getOrDefault(CommandRequirement.KEY, Collections.emptyList()));
        CommandRequirementBuilderModifier.addRequirement(requirement, requirements);
        return builder.meta(CommandRequirement.KEY, requirements);
    }

    private static void addRequirement(CommandRequirement requirement, List<CommandRequirement> destination) {
        for (CommandRequirement parent : requirement.parents()) {
            CommandRequirementBuilderModifier.addRequirement(parent, destination);
        }
        destination.add(requirement);
    }

    @Override
    public  @NonNull Command.Builder<? extends EasCommandSender> modifyBuilder(@NonNull A annotation, Command.Builder<EasCommandSender> builder) {
        return builder.apply(this.requirementProvider.apply(annotation));
    }
}

