/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.command.processor;

import java.util.function.Predicate;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.command.sender.EasCommandSender;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.lib.cloud.key.CloudKey;
import me.m56738.easyarmorstands.lib.cloud.permission.Permission;
import me.m56738.easyarmorstands.lib.cloud.permission.PredicatePermission;
import me.m56738.easyarmorstands.lib.kyori.adventure.key.Key;
import org.bukkit.entity.Player;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;

public class PropertyPermissionPredicate
implements Predicate<EasCommandSender> {
    private final PropertyType<?> type;

    public PropertyPermissionPredicate(PropertyType<?> type) {
        this.type = type;
    }

    @NotNull
    public static Permission createPermission(@Subst(value="n:v") String value) {
        return PropertyPermissionPredicate.createPermission(Key.key(value));
    }

    @NotNull
    public static Permission createPermission(Key key) {
        return PropertyPermissionPredicate.createPermission(EasyArmorStandsPlugin.getInstance().propertyTypeRegistry().get(key));
    }

    @NotNull
    public static Permission createPermission(PropertyType<?> type) {
        return PredicatePermission.of(CloudKey.of("property_permission_" + type.key().asString()), new PropertyPermissionPredicate(type));
    }

    @Override
    public boolean test(EasCommandSender sender) {
        if (sender instanceof EasPlayer) {
            Player player = ((EasPlayer)sender).player();
            return player.hasPermission("easyarmorstands.edit") && this.type.canChange(player);
        }
        return false;
    }
}

