/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.command;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.capability.CapabilityLoader;
import me.m56738.easyarmorstands.command.sender.EasCommandSender;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.lib.cloud.CommandManager;
import me.m56738.easyarmorstands.lib.cloud.annotation.specifier.Greedy;
import me.m56738.easyarmorstands.lib.cloud.annotations.Argument;
import me.m56738.easyarmorstands.lib.cloud.annotations.Command;
import me.m56738.easyarmorstands.lib.cloud.annotations.CommandDescription;
import me.m56738.easyarmorstands.lib.cloud.annotations.Permission;
import me.m56738.easyarmorstands.lib.cloud.annotations.suggestion.Suggestions;
import me.m56738.easyarmorstands.lib.cloud.context.CommandContext;
import me.m56738.easyarmorstands.lib.cloud.help.result.CommandEntry;
import me.m56738.easyarmorstands.lib.cloud.minecraft.extras.MinecraftHelp;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.event.ClickEvent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.event.HoverEventSource;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.NamedTextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.StyleSetter;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextDecoration;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.session.SessionImpl;
import me.m56738.easyarmorstands.session.SessionListener;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

@Command(value="eas")
public class GlobalCommands {
    private final CommandManager<EasCommandSender> commandManager;
    private final MinecraftHelp<EasCommandSender> help;
    private final SessionListener sessionListener;

    public GlobalCommands(CommandManager<EasCommandSender> commandManager, SessionListener sessionListener) {
        this.commandManager = commandManager;
        this.help = MinecraftHelp.createNative("/eas help", commandManager);
        this.sessionListener = sessionListener;
    }

    @Command(value="")
    @Permission(value={"easyarmorstands.help"})
    @CommandDescription(value="easyarmorstands.command.description")
    public void showOverview(EasCommandSender sender) {
        if (sender.get().hasPermission("easyarmorstands.version")) {
            String version = EasyArmorStandsPlugin.getInstance().getDescription().getVersion();
            sender.sendMessage(Component.text("EasyArmorStands v" + version, (TextColor)NamedTextColor.GOLD));
        } else {
            sender.sendMessage(Component.text("EasyArmorStands", (TextColor)NamedTextColor.GOLD));
        }
        if (sender.get().hasPermission("easyarmorstands.give")) {
            sender.sendMessage(Message.hint("easyarmorstands.hint.give-tool", Message.command("/eas give")));
        }
        sender.sendMessage(Message.hint("easyarmorstands.hint.show-help", Message.command("/eas help")));
    }

    @Command(value="help [query]")
    @Permission(value={"easyarmorstands.help"})
    @CommandDescription(value="easyarmorstands.command.description.help")
    public void help(EasCommandSender sender, @Argument(value="query", suggestions="help_queries") @Greedy String query) {
        this.help.queryCommands(query != null ? query : "", sender);
    }

    @Suggestions(value="help_queries")
    public List<String> suggestHelpQueries(CommandContext<EasCommandSender> ctx, String input) {
        return this.commandManager.createHelpHandler().queryRootIndex(ctx.sender()).entries().stream().map(CommandEntry::syntax).collect(Collectors.toList());
    }

    @Command(value="give")
    @Permission(value={"easyarmorstands.give"})
    @CommandDescription(value="easyarmorstands.command.description.give")
    public void give(EasPlayer sender) {
        sender.get().getInventory().addItem(new ItemStack[]{EasyArmorStandsPlugin.getInstance().createTool(sender.locale())});
        sender.sendMessage(Message.success("easyarmorstands.success.added-tool-to-inventory"));
        this.sessionListener.updateHeldItem(sender.get());
    }

    @Command(value="reload")
    @Permission(value={"easyarmorstands.reload"})
    @CommandDescription(value="easyarmorstands.command.description.reload")
    public void reloadConfig(EasCommandSender sender) {
        EasyArmorStandsPlugin.getInstance().reload();
        sender.sendMessage(Message.success("easyarmorstands.success.reloaded-config"));
    }

    @Command(value="version")
    @Permission(value={"easyarmorstands.version"})
    @CommandDescription(value="easyarmorstands.command.description.version")
    public void version(EasCommandSender sender) {
        EasyArmorStandsPlugin plugin = EasyArmorStandsPlugin.getInstance();
        String version = plugin.getDescription().getVersion();
        String url = "https://github.com/56738/EasyArmorStands";
        sender.sendMessage(Component.text("EasyArmorStands v" + version, (TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text(url).clickEvent(ClickEvent.openUrl(url)));
    }

    @Command(value="debug")
    @Permission(value={"easyarmorstands.debug"})
    @CommandDescription(value="easyarmorstands.command.description.debug")
    public void debug(EasCommandSender sender) {
        EasyArmorStandsPlugin plugin = EasyArmorStandsPlugin.getInstance();
        CapabilityLoader loader = plugin.getCapabilityLoader();
        String version = plugin.getDescription().getVersion();
        sender.sendMessage(Component.text("EasyArmorStands v" + version, (TextColor)NamedTextColor.GOLD, TextDecoration.UNDERLINED));
        sender.sendMessage(this.debugLine(Component.text("Server"), Component.text(Bukkit.getVersion())));
        sender.sendMessage(this.debugLine(Component.text("Bukkit"), Component.text(Bukkit.getBukkitVersion())));
        for (CapabilityLoader.Entry capability : loader.getCapabilities()) {
            StyleSetter<Component> value;
            Object instance = capability.getInstance();
            int attempts = capability.getAttempts();
            if (instance != null) {
                String packageName = capability.getType().getPackage().getName();
                String providerName = capability.getProvider().getClass().getName();
                if (providerName.startsWith(packageName)) {
                    providerName = providerName.substring(packageName.length());
                }
                NamedTextColor color = attempts > 1 ? NamedTextColor.YELLOW : NamedTextColor.GREEN;
                value = Component.text(providerName, (TextColor)color).hoverEvent((HoverEventSource)Component.text(instance.getClass().getName()));
            } else {
                value = Component.text("Not supported", (TextColor)NamedTextColor.RED);
            }
            sender.sendMessage(this.debugLine((Component)Component.text(capability.getName()).hoverEvent((HoverEventSource)Component.text(capability.getType().getName())), (Component)value));
        }
        if (sender instanceof EasPlayer) {
            SessionImpl session = ((EasPlayer)sender).session();
            Object element = null;
            if (session != null) {
                sender.sendMessage(Component.text("Current session:", (TextColor)NamedTextColor.GOLD));
                boolean first = true;
                for (Node node : session.getNodeStack()) {
                    sender.sendMessage(Component.text("* ", (TextColor)(first ? NamedTextColor.GREEN : NamedTextColor.GRAY)).append((Component)Component.text(node.getClass().getSimpleName()).hoverEvent((HoverEventSource)Component.text(node.getClass().getName()))));
                    first = false;
                }
                element = session.getElement();
            }
            if (element != null) {
                sender.sendMessage(Component.text("Selected element: ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text(element.getClass().getSimpleName(), (TextColor)NamedTextColor.GREEN).hoverEvent((HoverEventSource)Component.text(element.getClass().getName()))));
                TextComponent.Builder builder = Component.text();
                builder.color(NamedTextColor.GRAY);
                element.getProperties().forEach(property -> {
                    try {
                        this.appendPropertyDebug(builder, (Property)property);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to process property: " + property.getType().key(), e);
                    }
                });
                sender.sendMessage(builder);
            }
        }
    }

    private <T> void appendPropertyDebug(TextComponent.Builder builder, Property<T> property) {
        PropertyType<T> type = property.getType();
        T value = Objects.requireNonNull(property.getValue());
        TextComponent.Builder hover = Component.text();
        hover.append(Component.text(type.key().namespace() + ':', (TextColor)NamedTextColor.YELLOW).append(Component.text(type.key().value(), (TextColor)NamedTextColor.GOLD)));
        hover.appendNewline();
        hover.append(this.debugLine(Component.text("Type"), Component.text(type.getClass().getName())));
        hover.appendNewline();
        hover.append(this.debugLine(Component.text("Value"), type.getValueComponent(value)));
        String permission = type.getPermission();
        if (permission != null) {
            hover.appendNewline();
            hover.append(this.debugLine(Component.text("Permission"), Component.text(permission)));
        }
        if (!builder.children().isEmpty()) {
            builder.append((Component)Component.text(", "));
        }
        builder.append(type.getName().hoverEvent((HoverEventSource)hover.build()).clickEvent(ClickEvent.copyToClipboard(type.getValueString(value))));
    }

    private Component debugLine(Component key, Component value) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(key.applyFallbackStyle(NamedTextColor.GOLD))).append((Component)Component.text(": ", (TextColor)NamedTextColor.GRAY))).append(value.applyFallbackStyle(NamedTextColor.GRAY))).build();
    }
}

