/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.capability.mannequin.v1_21_10_spigot.property;

import me.m56738.easyarmorstands.api.SkinPart;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.MannequinPropertyTypes;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.util.ReflectionUtil;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.model.PlayerModelPart;
import org.jetbrains.annotations.NotNull;

public class MannequinSkinPartVisibleProperty
implements Property<Boolean> {
    private final Mannequin mannequin;
    private final PlayerModelPart part;
    private final PropertyType<Boolean> type;

    public MannequinSkinPartVisibleProperty(Mannequin mannequin, PlayerModelPart part, SkinPart skinPart) {
        this.mannequin = mannequin;
        this.part = part;
        this.type = MannequinPropertyTypes.SKIN_PART_VISIBLE.get(skinPart);
    }

    public static boolean isSupported() {
        return ReflectionUtil.hasClass("PlayerModelPart");
    }

    @Override
    @NotNull
    public PropertyType<Boolean> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Boolean getValue() {
        return this.mannequin.isModelPartShown(this.part);
    }

    @Override
    public boolean setValue(@NotNull Boolean value) {
        this.mannequin.setModelPartShown(this.part, value.booleanValue());
        return true;
    }
}

