/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.capability.mannequin.v1_21_10_paper;

import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.util.Objects;
import java.util.UUID;
import me.m56738.easyarmorstands.api.profile.Profile;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.object.ObjectContents;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.object.PlayerHeadObjectContents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolvableProfileWrapper
implements Profile {
    private final ResolvableProfile profile;

    public ResolvableProfileWrapper(ResolvableProfile profile) {
        this.profile = profile;
    }

    public ResolvableProfile getProfile() {
        return this.profile;
    }

    @Override
    @Nullable
    public String getName() {
        return this.profile.name();
    }

    @Override
    @Nullable
    public UUID getUniqueId() {
        return this.profile.uuid();
    }

    @Override
    @NotNull
    public Component asComponent() {
        PlayerHeadObjectContents.Builder builder = ObjectContents.playerHead();
        builder.name(this.profile.name());
        builder.id(this.profile.uuid());
        this.profile.properties().forEach(property -> builder.profileProperty(PlayerHeadObjectContents.property(property.getName(), property.getValue(), property.getSignature())));
        return Component.object(builder.build());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvableProfileWrapper that = (ResolvableProfileWrapper)o;
        return Objects.equals(this.profile, that.profile);
    }

    public int hashCode() {
        return Objects.hashCode(this.profile);
    }
}

