/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.capability.component.v1_16_paper;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.m56738.easyarmorstands.capability.CapabilityProvider;
import me.m56738.easyarmorstands.capability.Priority;
import me.m56738.easyarmorstands.capability.component.ComponentCapability;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.NamedTextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.Style;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextDecoration;
import me.m56738.easyarmorstands.util.NativeComponentMapper;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentCapabilityProvider
implements CapabilityProvider<ComponentCapability> {
    @Override
    public boolean isSupported() {
        NativeComponentMapper mapper = NativeComponentMapper.getInstance();
        if (mapper == null) {
            return false;
        }
        try {
            Entity.class.getMethod("customName", new Class[0]);
            Entity.class.getMethod("customName", mapper.getComponentClass());
            ItemMeta.class.getMethod("displayName", mapper.getComponentClass());
            ItemMeta.class.getMethod("lore", List.class);
            ItemStack.class.getMethod("displayName", new Class[0]);
            Bukkit.class.getMethod("createInventory", InventoryHolder.class, Integer.TYPE, mapper.getComponentClass());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public Priority getPriority() {
        return Priority.NORMAL;
    }

    @Override
    public ComponentCapability create(Plugin plugin) {
        try {
            return new ComponentCapabilityImpl();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ComponentCapabilityImpl
    implements ComponentCapability {
        private static final Style fallbackStyle = Style.style(NamedTextColor.WHITE, TextDecoration.ITALIC.withState(false));
        private final NativeComponentMapper mapper;
        private final MethodHandle getCustomName;
        private final MethodHandle setCustomName;
        private final MethodHandle setDisplayName;
        private final MethodHandle setLore;
        private final MethodHandle getItemDisplayName;
        private final MethodHandle createInventory;

        public ComponentCapabilityImpl() throws NoSuchMethodException, IllegalAccessException {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            this.mapper = Objects.requireNonNull(NativeComponentMapper.getInstance());
            this.getCustomName = lookup.findVirtual(Entity.class, "customName", MethodType.methodType(this.mapper.getComponentClass()));
            this.setCustomName = lookup.findVirtual(Entity.class, "customName", MethodType.methodType(Void.TYPE, this.mapper.getComponentClass()));
            this.setDisplayName = lookup.findVirtual(ItemMeta.class, "displayName", MethodType.methodType(Void.TYPE, this.mapper.getComponentClass()));
            this.setLore = lookup.findVirtual(ItemMeta.class, "lore", MethodType.methodType(Void.TYPE, List.class));
            this.getItemDisplayName = lookup.findVirtual(ItemStack.class, "displayName", MethodType.methodType(this.mapper.getComponentClass()));
            this.createInventory = lookup.findStatic(Bukkit.class, "createInventory", MethodType.methodType(Inventory.class, InventoryHolder.class, Integer.TYPE, this.mapper.getComponentClass()));
        }

        @Nullable
        private static Component style(@Nullable Component component) {
            if (component == null) {
                return null;
            }
            return component.applyFallbackStyle(fallbackStyle);
        }

        @Override
        @Nullable
        public Component getCustomName(@NotNull Entity entity) {
            try {
                return this.mapper.convertFromNative(this.getCustomName.invoke(entity));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setCustomName(@NotNull Entity entity, @Nullable Component name) {
            try {
                this.setCustomName.invoke(entity, this.mapper.convertToNative(name));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setDisplayName(@NotNull ItemMeta meta, @Nullable Component displayName) {
            try {
                this.setDisplayName.invoke(meta, this.mapper.convertToNative(ComponentCapabilityImpl.style(displayName)));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setLore(@NotNull ItemMeta meta, @NotNull @NotNull List<@NotNull Component> lore) {
            ArrayList<Object> nativeLore = new ArrayList<Object>(lore.size());
            for (Component component : lore) {
                nativeLore.add(this.mapper.convertToNative(ComponentCapabilityImpl.style(component)));
            }
            try {
                this.setLore.invoke(meta, nativeLore);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        @NotNull
        public Component getItemDisplayName(@NotNull ItemStack item) {
            try {
                return Objects.requireNonNull(this.mapper.convertFromNative(this.getItemDisplayName.invoke(item)));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        @NotNull
        public Inventory createInventory(InventoryHolder holder, int size, Component title) {
            Object nativeTitle = this.mapper.convertToNative(title);
            try {
                return this.createInventory.invoke(holder, size, nativeTitle);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

