/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.property;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.property.ElementPropertyRegistry;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.lib.kyori.adventure.key.Keyed;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyRegistry
implements PropertyContainer {
    private final Map<PropertyType, Property> properties = new TreeMap<PropertyType, Property>(Comparator.comparing(Keyed::key));

    @NotNull
    public static PropertyRegistry create(@NotNull Element element) {
        return new ElementPropertyRegistry(element);
    }

    public <T> void register(@NotNull Property<T> property) {
        this.properties.put(property.getType(), property);
    }

    @Override
    public void forEach(@NotNull @NotNull Consumer<@NotNull Property<?>> consumer) {
        for (Property property : this.properties.values()) {
            consumer.accept(property);
        }
    }

    @Override
    public <T> Property<T> getOrNull(@NotNull PropertyType<T> type) {
        return this.properties.get(type);
    }

    @Override
    public void commit(@Nullable Component description) {
    }
}

