/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.editor.tool;

import me.m56738.easyarmorstands.api.editor.Snapper;
import me.m56738.easyarmorstands.api.editor.tool.MoveTool;
import me.m56738.easyarmorstands.api.editor.tool.MoveToolSession;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.util.EasConversion;
import me.m56738.easyarmorstands.api.util.EasFormat;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LocationMoveTool
implements MoveTool {
    private final ToolContext context;
    private final PropertyContainer properties;
    private final Property<Location> locationProperty;

    LocationMoveTool(ToolContext context, PropertyContainer properties, Property<Location> locationProperty) {
        this.context = context;
        this.properties = properties;
        this.locationProperty = locationProperty;
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.context.position().getPosition();
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.context.rotation().getRotation();
    }

    @Override
    @NotNull
    public MoveToolSession start() {
        return new SessionImpl();
    }

    @Override
    public boolean canUse(@NotNull Player player) {
        return this.locationProperty.canChange(player);
    }

    private class SessionImpl
    implements MoveToolSession {
        private final Location originalLocation;
        private final Vector3dc originalPosition;
        private final Vector3d offset = new Vector3d();

        public SessionImpl() {
            this.originalLocation = ((Location)LocationMoveTool.this.locationProperty.getValue()).clone();
            this.originalPosition = EasConversion.fromBukkit(this.originalLocation.toVector());
        }

        @Override
        public void setChange(@NotNull Vector3dc change) {
            this.offset.set(change);
            Location location = this.originalLocation.clone();
            location.add(change.x(), change.y(), change.z());
            LocationMoveTool.this.locationProperty.setValue(location);
        }

        @Override
        public void snapChange(@NotNull Vector3d change, @NotNull Snapper context) {
            change.add(this.originalPosition);
            context.snapPosition(change);
            change.sub(this.originalPosition);
        }

        @Override
        @NotNull
        public Vector3dc getPosition() {
            return EasConversion.fromBukkit(((Location)LocationMoveTool.this.locationProperty.getValue()).toVector());
        }

        @Override
        public void setPosition(@NotNull Vector3dc position) {
            this.setChange(position.sub(this.originalPosition, this.offset));
        }

        @Override
        public void revert() {
            LocationMoveTool.this.locationProperty.setValue(this.originalLocation);
        }

        @Override
        public void commit(@Nullable Component description) {
            LocationMoveTool.this.properties.commit(description);
        }

        @Override
        public boolean isValid() {
            return LocationMoveTool.this.properties.isValid();
        }

        @Override
        @Nullable
        public Component getStatus() {
            return EasFormat.formatLocation((Location)LocationMoveTool.this.locationProperty.getValue());
        }

        @Override
        @Nullable
        public Component getDescription() {
            Component value = EasFormat.formatLocation((Location)LocationMoveTool.this.locationProperty.getValue());
            return Component.translatable("easyarmorstands.history.move", value);
        }

        @Override
        public boolean canSetPosition(Player player) {
            return player.hasPermission("easyarmorstands.position");
        }
    }
}

