/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.editor.button;

import java.util.Objects;
import java.util.function.Consumer;
import me.m56738.easyarmorstands.api.editor.EyeRay;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.Button;
import me.m56738.easyarmorstands.api.editor.button.ButtonResult;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.api.particle.PointParticle;
import me.m56738.easyarmorstands.api.util.PositionProvider;
import me.m56738.easyarmorstands.api.util.RotationProvider;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PointButton
implements Button {
    private final PointParticle particle;
    private final Session session;
    private final PositionProvider positionProvider;
    @Nullable
    private final RotationProvider rotationProvider;
    private final Vector3d position = new Vector3d();
    private double scale;
    private ParticleColor color = ParticleColor.WHITE;
    private int priority = 0;

    public PointButton(@NotNull Session session, @NotNull PositionProvider positionProvider, @Nullable RotationProvider rotationProvider) {
        this.session = session;
        this.positionProvider = positionProvider;
        this.rotationProvider = rotationProvider;
        this.particle = session.particleProvider().createPoint();
    }

    @NotNull
    public ParticleColor getColor() {
        return this.color;
    }

    public void setColor(@NotNull ParticleColor color) {
        this.color = Objects.requireNonNull(color);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public void update() {
        this.position.set(this.positionProvider.getPosition());
        this.scale = this.session.getScale(this.position);
    }

    @Override
    public void intersect(@NotNull EyeRay ray, @NotNull @NotNull Consumer<@NotNull ButtonResult> results) {
        Vector3dc intersection = ray.intersectPoint(this.position, this.scale);
        if (intersection != null) {
            results.accept(ButtonResult.of(intersection, this.priority));
        }
    }

    @Override
    public void updatePreview(boolean focused) {
        this.particle.setPosition(this.position);
        this.particle.setSize(this.scale / 16.0);
        if (this.rotationProvider != null) {
            this.particle.setRotation(this.rotationProvider.getRotation());
            this.particle.setBillboard(false);
        } else {
            this.particle.setBillboard(true);
        }
        this.particle.setColor(focused ? ParticleColor.YELLOW : this.color);
    }

    @Override
    public void showPreview() {
        this.session.addParticle(this.particle);
    }

    @Override
    public void hidePreview() {
        this.session.removeParticle(this.particle);
    }
}

