/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.editor.button;

import java.util.function.Consumer;
import me.m56738.easyarmorstands.api.editor.EyeRay;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.Button;
import me.m56738.easyarmorstands.api.editor.button.ButtonResult;
import me.m56738.easyarmorstands.api.particle.BoundingBoxParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.api.particle.PointParticle;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.api.util.BoundingBoxProvider;
import me.m56738.easyarmorstands.api.util.PositionProvider;
import me.m56738.easyarmorstands.api.util.RotationProvider;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.jetbrains.annotations.NotNull;

public final class BoundingBoxButton
implements Button {
    private final Session session;
    private final BoundingBoxProvider boxProvider;
    private final PositionProvider positionProvider;
    private final RotationProvider rotationProvider;
    private final Vector3d position = new Vector3d();
    private final Quaterniond rotation = new Quaterniond();
    private final PointParticle pointParticle;
    private final BoundingBoxParticle boxParticle;
    private double scale;
    private BoundingBox box;
    private boolean previewVisible;
    private boolean boxVisible;

    public BoundingBoxButton(@NotNull Session session, @NotNull BoundingBoxProvider boxProvider, @NotNull PositionProvider positionProvider, @NotNull RotationProvider rotationProvider) {
        this.session = session;
        this.pointParticle = session.particleProvider().createPoint();
        this.boxProvider = boxProvider;
        this.positionProvider = positionProvider;
        this.rotationProvider = rotationProvider;
        this.pointParticle.setBillboard(false);
        this.boxParticle = session.particleProvider().createAxisAlignedBox();
    }

    @Override
    public void update() {
        this.box = BoundingBox.of(this.boxProvider.getBoundingBox());
        this.position.set(this.positionProvider.getPosition());
        this.rotation.set(this.rotationProvider.getRotation());
        this.scale = this.session.getScale(this.position);
    }

    @Override
    public void intersect(@NotNull EyeRay ray, @NotNull @NotNull Consumer<@NotNull ButtonResult> results) {
        Vector3dc intersection = ray.intersectPoint(this.position, this.scale);
        if (intersection != null) {
            results.accept(ButtonResult.of(intersection));
        }
        if ((intersection = ray.intersectBox(this.box)) != null) {
            results.accept(ButtonResult.of(intersection, -1));
        }
    }

    @Override
    public void updatePreview(boolean focused) {
        boolean showBox;
        this.pointParticle.setPosition(this.position);
        this.pointParticle.setRotation(this.rotation);
        this.pointParticle.setColor(focused ? ParticleColor.YELLOW : ParticleColor.WHITE);
        this.pointParticle.setSize(this.scale / 16.0);
        this.boxParticle.setBoundingBox(this.box);
        boolean bl = showBox = focused && !this.box.getMinPosition().equals(this.box.getMaxPosition());
        if (this.previewVisible && showBox != this.boxVisible) {
            if (showBox) {
                this.session.addParticle(this.boxParticle);
            } else {
                this.session.removeParticle(this.boxParticle);
            }
        }
        this.boxVisible = showBox;
    }

    @Override
    public void showPreview() {
        this.previewVisible = true;
        this.session.addParticle(this.pointParticle);
        if (this.boxVisible) {
            this.session.addParticle(this.boxParticle);
        }
    }

    @Override
    public void hidePreview() {
        this.previewVisible = false;
        this.session.removeParticle(this.pointParticle);
        if (this.boxVisible) {
            this.session.removeParticle(this.boxParticle);
        }
    }
}

