/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.editor;

import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.lib.joml.Intersectiond;
import me.m56738.easyarmorstands.lib.joml.Matrix4dc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface EyeRay {
    @Contract(pure=true)
    @NotNull
    public World world();

    @Contract(pure=true)
    @NotNull
    public Vector3dc origin();

    @Contract(pure=true)
    @NotNull
    public Vector3dc target();

    @Contract(pure=true)
    @NotNull
    default public Vector3dc point(double distance) {
        Vector3dc origin = this.origin();
        return this.target().sub(origin, new Vector3d()).normalize(distance).add(origin);
    }

    @Contract(pure=true)
    public double length();

    @Contract(pure=true)
    public double threshold();

    @Contract(pure=true)
    public float yaw();

    @Contract(pure=true)
    public float pitch();

    @Contract(pure=true)
    @NotNull
    public Matrix4dc matrix();

    @Contract(pure=true)
    @NotNull
    public Matrix4dc inverseMatrix();

    default public boolean isInRange(@NotNull Location location) {
        return this.world().equals((Object)location.getWorld()) && this.isInRange(location.getX(), location.getY(), location.getZ());
    }

    default public boolean isInRange(@NotNull Vector3dc position) {
        return this.isInRange(position.x(), position.y(), position.z());
    }

    default public boolean isInRange(double x, double y, double z) {
        double range = this.length();
        return this.origin().distanceSquared(x, y, z) <= range * range;
    }

    @Contract(pure=true)
    @NotNull
    default public Vector3dc projectPoint(@NotNull Vector3dc position) {
        Vector3dc origin = this.origin();
        Vector3dc target = this.target();
        return Intersectiond.findClosestPointOnLineSegment(origin.x(), origin.y(), origin.z(), target.x(), target.y(), target.z(), position.x(), position.y(), position.z(), new Vector3d());
    }

    @Contract(pure=true)
    @Nullable
    public Vector3dc intersectPoint(@NotNull Vector3dc var1);

    @Contract(pure=true)
    @Nullable
    public Vector3dc intersectPoint(@NotNull Vector3dc var1, double var2);

    @Contract(pure=true)
    @Nullable
    public Vector3dc intersectLine(@NotNull Vector3dc var1, @NotNull Vector3dc var2);

    @Contract(pure=true)
    @Nullable
    public Vector3dc intersectLine(@NotNull Vector3dc var1, @NotNull Vector3dc var2, double var3);

    @Contract(pure=true)
    @Nullable
    public Vector3dc intersectPlane(@NotNull Vector3dc var1, @NotNull Vector3dc var2);

    @Contract(pure=true)
    @Nullable
    public Vector3dc intersectPlane(@NotNull Vector3dc var1, @NotNull Vector3dc var2, double var3);

    @Contract(pure=true)
    @Nullable
    public Vector3dc intersectCircle(@NotNull Vector3dc var1, @NotNull Vector3dc var2, double var3);

    @Contract(pure=true)
    @Nullable
    public Vector3dc intersectCircle(@NotNull Vector3dc var1, @NotNull Vector3dc var2, double var3, double var5);

    @Contract(pure=true)
    @Nullable
    public Vector3dc intersectBox(@NotNull BoundingBox var1);
}

