/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.session;

import me.m56738.easyarmorstands.api.editor.EyeRay;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.lib.gizmo.api.cursor.Cursor;
import me.m56738.easyarmorstands.lib.gizmo.api.cursor.Intersection;
import me.m56738.easyarmorstands.lib.joml.Matrix4d;
import me.m56738.easyarmorstands.lib.joml.Matrix4dc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EyeRayImpl
implements EyeRay {
    private final World world;
    private final Vector3dc origin;
    private final Vector3dc direction;
    private final Vector3dc target;
    private final double length;
    private final Cursor cursor;
    private final double threshold;
    private final float yaw;
    private final float pitch;
    private final Matrix4dc matrix;
    private Matrix4dc inverseMatrix;

    public EyeRayImpl(World world, Location location, double length, double threshold) {
        this.world = world;
        this.origin = Util.toVector3d(location);
        this.direction = Util.toVector3d(location.getDirection());
        this.target = this.origin.fma(length, this.direction, new Vector3d());
        this.length = length;
        this.cursor = Cursor.of(this.origin, this.target);
        this.threshold = threshold;
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.matrix = Util.toMatrix4d(location);
    }

    @Nullable
    private static Vector3dc convert(@Nullable Intersection intersection) {
        if (intersection != null) {
            return intersection.positionOnTarget();
        }
        return null;
    }

    @Override
    @NotNull
    public World world() {
        return this.world;
    }

    @Override
    @NotNull
    public Vector3dc origin() {
        return this.origin;
    }

    @Override
    @NotNull
    public Vector3dc target() {
        return this.target;
    }

    @Override
    @NotNull
    public Vector3dc point(double distance) {
        return this.origin.fma(distance, this.direction, new Vector3d());
    }

    @Override
    public double length() {
        return this.length;
    }

    @Override
    public double threshold() {
        return this.threshold;
    }

    @Override
    public float yaw() {
        return this.yaw;
    }

    @Override
    public float pitch() {
        return this.pitch;
    }

    @Override
    @NotNull
    public Matrix4dc matrix() {
        return this.matrix;
    }

    @Override
    @NotNull
    public Matrix4dc inverseMatrix() {
        if (this.inverseMatrix == null) {
            this.inverseMatrix = this.matrix.invert(new Matrix4d());
        }
        return this.inverseMatrix;
    }

    @Override
    @Nullable
    public Vector3dc intersectPoint(@NotNull Vector3dc position) {
        return this.intersectPoint(position, 1.0);
    }

    @Override
    @Nullable
    public Vector3dc intersectPoint(@NotNull Vector3dc position, double scale) {
        return EyeRayImpl.convert(this.cursor.intersectPoint(position, this.threshold() * scale));
    }

    @Override
    @Nullable
    public Vector3dc intersectLine(@NotNull Vector3dc start, @NotNull Vector3dc end) {
        return this.intersectLine(start, end, 1.0);
    }

    @Override
    @Nullable
    public Vector3dc intersectLine(@NotNull Vector3dc start, @NotNull Vector3dc end, double scale) {
        return EyeRayImpl.convert(this.cursor.intersectLine(start, end, this.threshold * scale));
    }

    @Override
    @Nullable
    public Vector3dc intersectPlane(@NotNull Vector3dc point, @NotNull Vector3dc normal) {
        return EyeRayImpl.convert(this.cursor.intersectPlane(point, normal));
    }

    @Override
    @Nullable
    public Vector3dc intersectPlane(@NotNull Vector3dc point, @NotNull Vector3dc normal, double range) {
        return EyeRayImpl.convert(this.cursor.intersectPlane(point, normal, range));
    }

    @Override
    @Nullable
    public Vector3dc intersectCircle(@NotNull Vector3dc point, @NotNull Vector3dc normal, double radius) {
        return this.intersectCircle(point, normal, radius, 1.0);
    }

    @Override
    @Nullable
    public Vector3dc intersectCircle(@NotNull Vector3dc point, @NotNull Vector3dc normal, double radius, double scale) {
        return EyeRayImpl.convert(this.cursor.intersectCircle(point, normal, radius, this.threshold * scale));
    }

    @Override
    @Nullable
    public Vector3dc intersectBox(@NotNull BoundingBox box) {
        return EyeRayImpl.convert(this.cursor.intersectBox(box.getMinPosition(), box.getMaxPosition()));
    }
}

