/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property.type;

import java.util.LinkedHashSet;
import java.util.Set;
import me.m56738.easyarmorstands.lib.configurate.CommentedConfigurationNode;
import me.m56738.easyarmorstands.lib.configurate.serialize.SerializationException;
import me.m56738.easyarmorstands.lib.geantyref.TypeToken;
import me.m56738.easyarmorstands.lib.kyori.adventure.key.Key;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.MiniMessage;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.m56738.easyarmorstands.property.type.ConfigurablePropertyType;
import org.jetbrains.annotations.NotNull;

public class StringSetPropertyType
extends ConfigurablePropertyType<Set<String>> {
    private Component separator;
    private Component empty;
    private Integer threshold;
    private String multiple;

    public StringSetPropertyType(@NotNull Key key) {
        super(key, new TypeToken<Set<String>>(){});
    }

    @Override
    public void load(@NotNull CommentedConfigurationNode config) throws SerializationException {
        super.load(config);
        this.separator = ((CommentedConfigurationNode)config.node(new Object[]{"value", "separator"})).get(Component.class);
        this.empty = ((CommentedConfigurationNode)config.node(new Object[]{"value", "empty"})).get(Component.class);
        this.threshold = ((CommentedConfigurationNode)config.node(new Object[]{"value", "threshold"})).get(Integer.class);
        this.multiple = ((CommentedConfigurationNode)config.node(new Object[]{"value", "multiple"})).get(String.class);
    }

    @Override
    @NotNull
    public Component getValueComponent(@NotNull Set<String> value) {
        if (this.threshold != null && this.threshold >= 0 && value.size() >= this.threshold) {
            return MiniMessage.miniMessage().deserialize(this.multiple, (TagResolver)Placeholder.component("amount", Component.text(value.size())));
        }
        TextComponent.Builder builder = Component.text();
        boolean first = true;
        for (String s : value) {
            if (!first) {
                builder.append(this.separator);
            }
            builder.append((Component)Component.text(s));
            first = false;
        }
        if (first) {
            return this.empty;
        }
        return builder.build();
    }

    @Override
    @NotNull
    public Set<String> cloneValue(@NotNull Set<String> value) {
        return new LinkedHashSet<String>(value);
    }
}

