/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property.type;

import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.api.property.type.PropertyTypeRegistry;
import me.m56738.easyarmorstands.lib.configurate.CommentedConfigurationNode;
import me.m56738.easyarmorstands.lib.configurate.ConfigurateException;
import me.m56738.easyarmorstands.lib.configurate.serialize.SerializationException;
import me.m56738.easyarmorstands.lib.kyori.adventure.key.Key;
import me.m56738.easyarmorstands.property.type.ConfigurablePropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyTypeRegistryImpl
implements PropertyTypeRegistry {
    private final Map<Key, PropertyType> types = new TreeMap<Key, PropertyType>();
    private CommentedConfigurationNode currentConfig;

    @Override
    public void register(@NotNull PropertyType<?> type) {
        this.types.put(type.key(), type);
        if (type instanceof ConfigurablePropertyType) {
            try {
                this.load(type);
            }
            catch (SerializationException e) {
                EasyArmorStandsPlugin.getInstance().getLogger().severe("Failed to load property " + type.key() + ": " + e.getMessage());
            }
            catch (Exception e) {
                EasyArmorStandsPlugin.getInstance().getLogger().log(Level.SEVERE, "Failed to load property " + type.key(), e);
            }
        }
    }

    @Override
    @Nullable
    public PropertyType<?> getOrNull(@NotNull Key key) {
        return this.types.get(key);
    }

    public void load(CommentedConfigurationNode config) throws SerializationException {
        this.currentConfig = config;
        for (PropertyType type : this.types.values()) {
            this.load(type);
        }
    }

    private void load(PropertyType<?> type) throws SerializationException {
        if (this.currentConfig == null) {
            return;
        }
        Key key = type.key();
        try {
            type.load((CommentedConfigurationNode)this.currentConfig.node(new Object[]{key.asString()}));
        }
        catch (ConfigurateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load property " + key, e);
        }
    }
}

