/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property.type;

import java.util.EnumMap;
import me.m56738.easyarmorstands.lib.configurate.CommentedConfigurationNode;
import me.m56738.easyarmorstands.lib.configurate.serialize.SerializationException;
import me.m56738.easyarmorstands.lib.kyori.adventure.key.Key;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.property.type.ConfigurablePropertyType;
import org.jetbrains.annotations.NotNull;

public class EnumPropertyType<T extends Enum<T>>
extends ConfigurablePropertyType<T> {
    protected final T[] values;
    private final EnumMap<T, Component> valueNames;

    public EnumPropertyType(@NotNull Key key, Class<T> type) {
        super(key, type);
        this.valueNames = new EnumMap(type);
        this.values = (Enum[])type.getEnumConstants();
    }

    @Override
    public void load(@NotNull CommentedConfigurationNode config) throws SerializationException {
        super.load(config);
        for (T value : this.values) {
            this.valueNames.put(value, ((CommentedConfigurationNode)config.node(new Object[]{"value", ((Enum)value).name()})).get(Component.class, Component.text(((Enum)value).name())));
        }
    }

    @Override
    @NotNull
    public Component getValueComponent(@NotNull T value) {
        return this.valueNames.get(value);
    }
}

