/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property.type;

import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.item.SimpleItemTemplate;
import me.m56738.easyarmorstands.lib.configurate.CommentedConfigurationNode;
import me.m56738.easyarmorstands.lib.configurate.serialize.SerializationException;
import me.m56738.easyarmorstands.lib.geantyref.TypeToken;
import me.m56738.easyarmorstands.lib.kyori.adventure.key.Key;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.permission.Permissions;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurablePropertyType<T>
implements PropertyType<T> {
    @NotNull
    private final Key key;
    @NotNull
    private final TypeToken<T> valueType;
    protected SimpleItemTemplate buttonTemplate;
    @Nullable
    private String permission;
    private Component name;
    private Permission registeredPermission;

    public ConfigurablePropertyType(@NotNull Key key, @NotNull TypeToken<T> valueType) {
        this.key = key;
        this.valueType = valueType;
    }

    public ConfigurablePropertyType(@NotNull Key key, @NotNull Class<T> valueType) {
        this(key, TypeToken.get(valueType));
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    @NotNull
    public TypeToken<T> getValueType() {
        return this.valueType;
    }

    @Override
    public void load(@NotNull CommentedConfigurationNode config) throws SerializationException {
        this.permission = ((CommentedConfigurationNode)config.node(new Object[]{"permission"})).getString();
        this.name = ((CommentedConfigurationNode)config.node(new Object[]{"name"})).require(Component.class);
        this.buttonTemplate = ((CommentedConfigurationNode)config.node(new Object[]{"button"})).get(SimpleItemTemplate.class);
        if (this.registeredPermission != null) {
            Permissions.unregister(this.registeredPermission);
        }
        this.registeredPermission = this.permission != null ? Permissions.register(new Permission(this.permission, "Allow editing " + this.key.asString())) : null;
    }

    @Override
    @Nullable
    public String getPermission() {
        return this.permission;
    }

    @Override
    @NotNull
    public Component getName() {
        if (this.name == null) {
            throw new IllegalStateException("Property not configured: " + this.key);
        }
        return this.name;
    }
}

