/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property.entity;

import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.capability.equipment.EquipmentCapability;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EntityEquipmentProperty
implements Property<ItemStack> {
    private final EntityEquipment equipment;
    private final EquipmentSlot slot;
    private final PropertyType<ItemStack> type;
    private final EquipmentCapability equipmentCapability;

    public EntityEquipmentProperty(EntityEquipment equipment, EquipmentSlot slot, EquipmentCapability equipmentCapability) {
        this.equipment = equipment;
        this.slot = slot;
        this.type = EntityPropertyTypes.EQUIPMENT.get(slot);
        this.equipmentCapability = equipmentCapability;
    }

    @Override
    @NotNull
    public PropertyType<ItemStack> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ItemStack getValue() {
        return Util.wrapItem(this.equipmentCapability.getItem(this.equipment, this.slot));
    }

    @Override
    public boolean setValue(@NotNull ItemStack value) {
        this.equipmentCapability.setItem(this.equipment, this.slot, value);
        return true;
    }
}

