/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.menu.slot;

import java.util.Locale;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.menu.MenuClick;
import me.m56738.easyarmorstands.api.menu.MenuSlot;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.GameMode;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemPropertySlot
implements MenuSlot {
    private final Property<ItemStack> property;
    private final PropertyContainer container;

    public ItemPropertySlot(Property<ItemStack> property, PropertyContainer container) {
        this.property = property;
        this.container = container;
    }

    public Property<ItemStack> getProperty() {
        return this.property;
    }

    public PropertyContainer getContainer() {
        return this.container;
    }

    @Override
    public ItemStack getItem(Locale locale) {
        return Util.wrapItem(this.property.getValue());
    }

    @Override
    public void onClick(@NotNull MenuClick click) {
        if (click.isShiftClick()) {
            EasyArmorStandsPlugin.getInstance().getClipboard(click.player()).handlePropertyShiftClick(this.property, click);
            return;
        }
        if (!this.property.canChange(click.player())) {
            return;
        }
        if (click.player().getGameMode() == GameMode.CREATIVE) {
            click.allow();
            click.queueTask(() -> {
                ItemStack item = click.menu().getInventory().getItem(click.index());
                if (this.property.setValue(Util.wrapItem(item))) {
                    this.container.commit();
                } else {
                    click.player().setItemOnCursor(item);
                    click.menu().updateItem(click.index());
                }
            });
            return;
        }
        if (!click.isLeftClick()) {
            return;
        }
        click.queueTask(() -> {
            ItemStack itemInCursor = click.cursor();
            ItemStack itemInProperty = this.property.getValue();
            if (this.property.setValue(itemInCursor)) {
                click.player().setItemOnCursor(itemInProperty);
                this.container.commit();
                click.menu().updateItem(click.index());
            }
        });
    }
}

