/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.menu.slot;

import java.util.Locale;
import me.m56738.easyarmorstands.api.element.DestroyableElement;
import me.m56738.easyarmorstands.api.menu.MenuClick;
import me.m56738.easyarmorstands.api.menu.MenuSlot;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.history.action.ElementDestroyAction;
import me.m56738.easyarmorstands.item.SimpleItemTemplate;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DestroySlot
implements MenuSlot {
    private final DestroyableElement element;
    private final SimpleItemTemplate itemTemplate;
    private final TagResolver resolver;

    public DestroySlot(DestroyableElement element, SimpleItemTemplate itemTemplate, TagResolver resolver) {
        this.element = element;
        this.itemTemplate = itemTemplate;
        this.resolver = resolver;
    }

    @Override
    public ItemStack getItem(Locale locale) {
        return this.itemTemplate.render(locale, this.resolver);
    }

    @Override
    public void onClick(@NotNull MenuClick click) {
        if (!click.isLeftClick()) {
            return;
        }
        EasPlayer context = new EasPlayer(click.player());
        if (!context.canDestroyElement(this.element)) {
            return;
        }
        context.history().push(new ElementDestroyAction(this.element));
        this.element.destroy();
        click.close();
    }
}

