/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.menu.slot;

import java.util.Locale;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.element.MenuElement;
import me.m56738.easyarmorstands.api.menu.Menu;
import me.m56738.easyarmorstands.api.menu.MenuClick;
import me.m56738.easyarmorstands.api.menu.MenuClickInterceptor;
import me.m56738.easyarmorstands.api.menu.MenuSlot;
import me.m56738.easyarmorstands.capability.itemcolor.ItemColorCapability;
import me.m56738.easyarmorstands.color.ColorPickerContextImpl;
import me.m56738.easyarmorstands.item.SimpleItemTemplate;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.m56738.easyarmorstands.menu.slot.ItemPropertySlot;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.jetbrains.annotations.NotNull;

public class ColorPickerSlot
implements MenuSlot,
MenuClickInterceptor {
    private final SimpleItemTemplate itemTemplate;
    private final SimpleItemTemplate activeItemTemplate;
    private final TagResolver resolver;
    private final MenuElement element;
    private boolean active;

    public ColorPickerSlot(SimpleItemTemplate itemTemplate, SimpleItemTemplate activeItemTemplate, TagResolver resolver, MenuElement element) {
        this.itemTemplate = itemTemplate;
        this.activeItemTemplate = activeItemTemplate;
        this.resolver = resolver;
        this.element = element;
    }

    private SimpleItemTemplate getItemTemplate() {
        return this.active ? this.activeItemTemplate : this.itemTemplate;
    }

    @Override
    public ItemStack getItem(Locale locale) {
        ItemMeta meta;
        ItemStack item = this.getItemTemplate().render(locale, this.resolver);
        if (this.active && (meta = item.getItemMeta()) != null) {
            LeatherArmorMeta armorMeta = (LeatherArmorMeta)meta;
            armorMeta.setColor(Color.YELLOW);
            item.setItemMeta(meta);
        }
        return item;
    }

    @Override
    public void onClick(@NotNull MenuClick click) {
        if (this.active) {
            this.active = false;
            click.updateItem();
            return;
        }
        if (!click.isLeftClick() || click.cursor().getType() != Material.AIR) {
            return;
        }
        Menu menu = click.menu();
        int size = menu.getSize();
        ItemPropertySlot foundSlot = null;
        int foundSlots = 0;
        for (int i = 0; i < size; ++i) {
            ItemPropertySlot itemSlot;
            MenuSlot slot = menu.getSlot(i);
            if (!(slot instanceof ItemPropertySlot) || !this.isApplicable(itemSlot = (ItemPropertySlot)slot)) continue;
            foundSlot = itemSlot;
            ++foundSlots;
        }
        if (foundSlots == 1) {
            this.open(click.player(), foundSlot);
        } else {
            this.active = true;
            click.interceptNextClick(this);
        }
        click.updateItem();
    }

    @Override
    public void interceptClick(@NotNull MenuClick click) {
        ItemPropertySlot itemSlot;
        this.active = false;
        click.updateItem(this);
        if (!click.isLeftClick() || click.cursor().getType() != Material.AIR) {
            return;
        }
        MenuSlot slot = click.slot();
        if (slot instanceof ItemPropertySlot && this.isApplicable(itemSlot = (ItemPropertySlot)slot)) {
            this.open(click.player(), itemSlot);
        }
    }

    private void open(Player player, ItemPropertySlot itemSlot) {
        Menu menu = EasyArmorStandsPlugin.getInstance().createColorPicker(player, new ColorPickerContextImpl(itemSlot));
        menu.addCloseListener((p, m) -> this.element.openMenu(p));
        player.openInventory(menu.getInventory());
    }

    private boolean isApplicable(ItemPropertySlot slot) {
        ItemStack item = slot.getProperty().getValue();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return EasyArmorStandsPlugin.getInstance().getCapability(ItemColorCapability.class).hasColor(meta);
    }
}

