/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo.bukkit.display.v1_19_4;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import me.m56738.easyarmorstands.lib.gizmo.AbstractCubeGizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.color.GizmoColor;
import me.m56738.easyarmorstands.lib.gizmo.bukkit.display.JOMLMapper;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DisplayCubeGizmo_v1_19_4
extends AbstractCubeGizmo {
    private static final Quaterniondc IDENTITY = new Quaterniond();
    private static final Map<GizmoColor, BlockData> COLORS = new HashMap<GizmoColor, BlockData>();
    private static final MethodHandle spawnHandle = DisplayCubeGizmo_v1_19_4.findSpawnHandle();
    private final Player player;
    private final Plugin plugin;
    private final JOMLMapper mapper;
    @Nullable
    private BlockDisplay entity;

    public DisplayCubeGizmo_v1_19_4(Player player, Plugin plugin, JOMLMapper mapper) {
        this.player = player;
        this.plugin = plugin;
        this.mapper = mapper;
    }

    private static MethodHandle findSpawnHandle() {
        try {
            return MethodHandles.publicLookup().findVirtual(World.class, "spawn", MethodType.methodType(Entity.class, Location.class, Class.class, org.bukkit.util.Consumer.class));
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public void show() {
        this.entity = this.spawn(this.player.getWorld(), this.getLocation(), this::configure);
        if (this.plugin.isEnabled()) {
            this.player.showEntity(this.plugin, (Entity)this.entity);
        }
        this.checkAndClearDirty();
    }

    @Override
    public void update() {
        if (this.entity == null) {
            return;
        }
        if (this.checkAndClearDirty()) {
            this.entity.teleport(this.getLocation());
            this.update(this.entity);
        }
    }

    @Override
    public void hide() {
        if (this.entity == null) {
            return;
        }
        if (this.plugin.isEnabled()) {
            this.player.hideEntity(this.plugin, (Entity)this.entity);
        }
        this.entity.remove();
        this.entity = null;
    }

    @NotNull
    protected Location getLocation() {
        Vector3dc position = this.getPosition();
        return new Location(this.player.getWorld(), position.x(), position.y(), position.z());
    }

    @NotNull
    protected BlockDisplay spawn(@NotNull World world, @NotNull Location location, @NotNull Consumer<BlockDisplay> consumer) {
        Objects.requireNonNull(spawnHandle);
        try {
            return spawnHandle.invoke(world, location, BlockDisplay.class, this::configure);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void configure(@NotNull BlockDisplay entity) {
        entity.setPersistent(false);
        entity.setVisibleByDefault(false);
        entity.setMetadata("gizmo", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)this));
        entity.setBrightness(new Display.Brightness(15, 15));
        entity.setGlowing(true);
        this.update(entity);
    }

    protected void update(@NotNull BlockDisplay entity) {
        GizmoColor color = this.getColor();
        entity.setBlock(COLORS.get(color));
        entity.setGlowColorOverride(Color.fromRGB((int)color.asRGB()));
        entity.setTransformation(this.mapper.createTransformation(this.getOffset(), this.getRotation(), this.getScale(), IDENTITY));
        entity.setBillboard(this.isBillboard() ? Display.Billboard.CENTER : Display.Billboard.FIXED);
    }

    static {
        COLORS.put(GizmoColor.WHITE, Material.WHITE_CONCRETE.createBlockData());
        COLORS.put(GizmoColor.RED, Material.RED_CONCRETE.createBlockData());
        COLORS.put(GizmoColor.GREEN, Material.LIME_CONCRETE.createBlockData());
        COLORS.put(GizmoColor.BLUE, Material.BLUE_CONCRETE.createBlockData());
        COLORS.put(GizmoColor.YELLOW, Material.YELLOW_CONCRETE.createBlockData());
        COLORS.put(GizmoColor.GRAY, Material.LIGHT_GRAY_CONCRETE.createBlockData());
        COLORS.put(GizmoColor.AQUA, Material.LIGHT_BLUE_CONCRETE.createBlockData());
    }
}

