/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo.api;

import java.util.List;
import me.m56738.easyarmorstands.lib.gizmo.AbstractCircleGizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.CircleGizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.GizmoAxis;
import me.m56738.easyarmorstands.lib.gizmo.api.LineGizmo;
import me.m56738.easyarmorstands.lib.joml.Math;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Vector3d;

class LineCircleGizmo
extends AbstractCircleGizmo
implements CircleGizmo {
    private final List<LineGizmo> pieces;

    LineCircleGizmo(List<LineGizmo> pieces) {
        this.pieces = pieces;
    }

    @Override
    public void show() {
        this.updatePieces();
        for (LineGizmo piece : this.pieces) {
            piece.show();
        }
    }

    @Override
    public void update() {
        this.updatePieces();
        for (LineGizmo piece : this.pieces) {
            piece.update();
        }
    }

    @Override
    public void hide() {
        for (LineGizmo piece : this.pieces) {
            piece.hide();
        }
    }

    private void updatePieces() {
        if (!this.checkAndClearDirty()) {
            return;
        }
        double radius = this.getRadius();
        double width = this.getWidth();
        double pieceAngle = java.lang.Math.PI * 2 / (double)this.pieces.size();
        double pieceLength = 2.0 * Math.tan(pieceAngle / 2.0) * (radius + width / 2.0);
        GizmoAxis rotationAxis = this.getAxis();
        GizmoAxis pieceAxis = rotationAxis.next();
        GizmoAxis offsetAxis = pieceAxis.next();
        Vector3d pieceOffset = new Vector3d();
        pieceAxis.setValue(pieceOffset, -pieceLength / 2.0);
        offsetAxis.setValue(pieceOffset, radius);
        double currentAngle = 0.0;
        Quaterniond currentRotation = new Quaterniond();
        Vector3d currentOffset = new Vector3d();
        for (LineGizmo piece : this.pieces) {
            piece.setPosition(this.getPosition());
            piece.setRotation(this.getRotation().rotateAxis(currentAngle, rotationAxis.direction(), currentRotation));
            piece.setOffset(pieceOffset.rotate(currentRotation, currentOffset).add(this.getOffset()));
            piece.setAxis(pieceAxis);
            piece.setWidth(width);
            piece.setLength(pieceLength);
            piece.setColor(this.getColor());
            currentAngle += pieceAngle;
        }
    }
}

