/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo;

import java.util.Objects;
import me.m56738.easyarmorstands.lib.gizmo.AbstractGizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.CircleGizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.GizmoAxis;
import me.m56738.easyarmorstands.lib.gizmo.api.cursor.Cursor;
import me.m56738.easyarmorstands.lib.gizmo.api.cursor.Intersection;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractCircleGizmo
extends AbstractGizmo
implements CircleGizmo {
    private GizmoAxis axis = DEFAULT_AXIS;
    private double radius = 1.0;
    private double width = 0.03125;

    @Override
    @NotNull
    public GizmoAxis getAxis() {
        return this.axis;
    }

    @Override
    public void setAxis(@NotNull GizmoAxis axis) {
        if (!Objects.equals((Object)this.axis, (Object)axis)) {
            this.axis = axis;
            this.markDirty();
        }
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double radius) {
        if (!Objects.equals(this.radius, radius)) {
            this.radius = radius;
            this.markDirty();
        }
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(double width) {
        if (!Objects.equals(this.width, width)) {
            this.width = width;
            this.markDirty();
        }
    }

    @Override
    @Nullable
    public Intersection intersect(@NotNull Cursor cursor, double threshold) {
        Vector3d center = this.getPosition().add(this.getOffset(), new Vector3d());
        Vector3d axis = this.getAxis().direction().rotate(this.getRotation(), new Vector3d());
        double radius = this.getRadius();
        return cursor.intersectCircle(center, axis, radius, threshold);
    }
}

