/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.history.action;

import java.util.List;
import java.util.UUID;
import me.m56738.easyarmorstands.context.ChangeContext;
import me.m56738.easyarmorstands.history.action.Action;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.NamedTextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupAction
implements Action {
    private final Action[] actions;
    private Component description;

    public GroupAction(List<? extends Action> actions, @Nullable Component description) {
        this.description = description;
        this.actions = actions.toArray(new Action[0]);
    }

    @Override
    public boolean execute(ChangeContext context) {
        boolean ok = true;
        for (Action action : this.actions) {
            ok &= action.execute(context);
        }
        return ok;
    }

    @Override
    public boolean undo(ChangeContext context) {
        boolean ok = true;
        for (int i = this.actions.length - 1; i >= 0; --i) {
            ok &= this.actions[i].undo(context);
        }
        return ok;
    }

    @Override
    public Component describe() {
        if (this.description == null) {
            TextComponent.Builder builder = Component.text();
            for (int i = 0; i < this.actions.length; ++i) {
                if (i != 0) {
                    builder.append((Component)Component.text(", ", (TextColor)NamedTextColor.DARK_GRAY));
                }
                builder.append(this.actions[i].describe());
            }
            this.description = builder.build();
        }
        return this.description;
    }

    @Override
    public void onEntityReplaced(@NotNull UUID oldId, @NotNull UUID newId) {
        for (Action action : this.actions) {
            action.onEntityReplaced(oldId, newId);
        }
    }
}

