/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.group.tool;

import java.util.List;
import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.Snapper;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateToolSession;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.group.tool.GroupScalarToolSession;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupAxisRotateTool
implements AxisRotateTool {
    private final ToolContext context;
    private final Axis axis;
    private final List<AxisRotateTool> tools;

    public GroupAxisRotateTool(ToolContext context, Axis axis, List<AxisRotateTool> tools) {
        this.context = context;
        this.axis = axis;
        this.tools = tools;
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.context.position().getPosition();
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.context.rotation().getRotation();
    }

    @Override
    @NotNull
    public Axis getAxis() {
        return this.axis;
    }

    @Override
    @NotNull
    public AxisRotateToolSession start() {
        return new SessionImpl();
    }

    @Override
    public boolean canUse(@NotNull Player player) {
        for (AxisRotateTool tool : this.tools) {
            if (!tool.canUse(player)) continue;
            return true;
        }
        return false;
    }

    private class SessionImpl
    extends GroupScalarToolSession<AxisRotateToolSession>
    implements AxisRotateToolSession {
        private double change;

        private SessionImpl() {
            super(GroupAxisRotateTool.this.tools);
        }

        @Override
        public void setChange(double change) {
            this.change = change;
            for (AxisRotateToolSession session : this.sessions) {
                session.setChange(change);
            }
        }

        @Override
        public double snapChange(double change, @NotNull Snapper context) {
            return context.snapAngle(change);
        }

        @Override
        @Nullable
        public Component getStatus() {
            return Util.formatAngle(this.change);
        }

        @Override
        @Nullable
        public Component getDescription() {
            TextComponent count = Component.text(this.sessions.size());
            TextComponent axisName = Component.text(GroupAxisRotateTool.this.axis.getName(), TextColor.color(GroupAxisRotateTool.this.axis.getColor()));
            return Message.component("easyarmorstands.history.group.rotate-axis", count, axisName);
        }
    }
}

