/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.fancyholograms.element;

import de.oliver.fancyholograms.api.HologramManager;
import de.oliver.fancyholograms.api.hologram.Hologram;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.Button;
import me.m56738.easyarmorstands.api.editor.button.PointButton;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.editor.tool.ToolProvider;
import me.m56738.easyarmorstands.api.element.DestroyableElement;
import me.m56738.easyarmorstands.api.element.EditableElement;
import me.m56738.easyarmorstands.api.element.MenuElement;
import me.m56738.easyarmorstands.api.element.SelectableElement;
import me.m56738.easyarmorstands.api.menu.MenuFactory;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.PropertyRegistry;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.editor.EntityPositionProvider;
import me.m56738.easyarmorstands.editor.EntityRotationProvider;
import me.m56738.easyarmorstands.fancyholograms.FancyHologramsAddon;
import me.m56738.easyarmorstands.fancyholograms.editor.node.HologramRootNode;
import me.m56738.easyarmorstands.fancyholograms.element.HologramElementReference;
import me.m56738.easyarmorstands.fancyholograms.element.HologramElementType;
import me.m56738.easyarmorstands.fancyholograms.element.HologramToolProvider;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.session.SessionImpl;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class HologramElement
implements SelectableElement,
DestroyableElement,
EditableElement,
MenuElement {
    private final HologramElementType type;
    private final HologramManager manager;
    private final Hologram hologram;
    private final FancyHologramsAddon addon;
    private final PropertyRegistry properties = PropertyRegistry.create(this);

    public HologramElement(HologramElementType type, HologramManager manager, Hologram hologram, FancyHologramsAddon addon) {
        this.type = type;
        this.manager = manager;
        this.hologram = hologram;
        this.addon = addon;
    }

    @Override
    public boolean canEdit(@NotNull Player player) {
        return player.hasPermission("easyarmorstands.fancyholograms.edit");
    }

    @Override
    public boolean canDestroy(@NotNull Player player) {
        return player.hasPermission("easyarmorstands.fancyholograms.destroy");
    }

    @Override
    public void destroy() {
        this.manager.removeHologram(this.hologram);
    }

    @Override
    @NotNull
    public Button createButton(@NotNull Session session) {
        return new PointButton(session, new EntityPositionProvider(this.properties), new EntityRotationProvider(this.properties));
    }

    @Override
    @NotNull
    public Node createNode(@NotNull Session session) {
        return new HologramRootNode(session, this);
    }

    @Override
    @NotNull
    public ToolProvider getTools(@NotNull PropertyContainer properties) {
        return new HologramToolProvider(properties);
    }

    @Override
    public void openMenu(@NotNull Player player) {
        MenuFactory factory = this.addon.getMenuFactory(this.hologram.getData());
        if (factory != null) {
            SessionImpl session = EasyArmorStandsPlugin.getInstance().sessionManager().getSession(player);
            EasyArmorStandsPlugin.getInstance().openMenu(player, session, factory, this);
        }
    }

    @Override
    @NotNull
    public Component getName() {
        return Component.text(this.hologram.getName());
    }

    @Override
    @NotNull
    public HologramElementType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public PropertyRegistry getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public HologramElementReference getReference() {
        return new HologramElementReference(this.type, this.manager, this.hologram.getName());
    }

    @Override
    public boolean isValid() {
        return this.manager.getHologram(this.hologram.getName()).isPresent();
    }

    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        return BoundingBox.of((Vector3dc)Util.toVector3d(this.hologram.getData().getLocation()));
    }
}

