/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.tool;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.Snapper;
import me.m56738.easyarmorstands.api.editor.tool.AxisMoveTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisMoveToolSession;
import me.m56738.easyarmorstands.api.util.PositionProvider;
import me.m56738.easyarmorstands.api.util.RotationProvider;
import me.m56738.easyarmorstands.editor.box.BoundingBoxEditor;
import me.m56738.easyarmorstands.editor.box.BoundingBoxEditorSession;
import me.m56738.easyarmorstands.lib.joml.Math;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoxResizeTool
implements AxisMoveTool {
    private final BoundingBoxEditor editor;
    private final PositionProvider positionProvider;
    private final RotationProvider rotationProvider;
    private final Axis axis;
    private final boolean end;

    public BoxResizeTool(BoundingBoxEditor editor, PositionProvider positionProvider, RotationProvider rotationProvider, Axis axis, boolean end) {
        this.editor = editor;
        this.positionProvider = positionProvider;
        this.rotationProvider = rotationProvider;
        this.axis = axis;
        this.end = end;
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.positionProvider.getPosition();
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.rotationProvider.getRotation();
    }

    @Override
    @NotNull
    public Axis getAxis() {
        return this.axis;
    }

    @Override
    public boolean canUse(@NotNull Player player) {
        return this.editor.canResize(player);
    }

    @Override
    @NotNull
    public AxisMoveToolSession start() {
        return new SessionImpl(this.editor.start());
    }

    private class SessionImpl
    implements AxisMoveToolSession {
        private final BoundingBoxEditorSession session;
        private final Vector3dc originalCenter;
        private final float originalWidth;
        private final float originalHeight;
        private final float originalValue;

        public SessionImpl(BoundingBoxEditorSession session) {
            this.session = session;
            this.originalCenter = session.getBoundingBox().getCenter(new Vector3d());
            this.originalWidth = session.getWidth();
            this.originalHeight = session.getHeight();
            this.originalValue = BoxResizeTool.this.axis == Axis.Y ? this.originalHeight : this.originalWidth;
        }

        @Override
        public void setChange(double change) {
            if (!BoxResizeTool.this.end) {
                change = -change;
            }
            if (BoxResizeTool.this.axis == Axis.Y) {
                double offset = change / 2.0;
                if (!BoxResizeTool.this.end) {
                    offset = -offset;
                }
                float height = this.originalHeight + (float)change;
                Vector3d center = this.originalCenter.add(0.0, offset, 0.0, new Vector3d());
                if (this.session.setHeight(Math.abs(height))) {
                    this.session.setCenter(center);
                }
            } else {
                Vector3d offset = new Vector3d();
                BoxResizeTool.this.axis.setValue(offset, change / 2.0);
                if (!BoxResizeTool.this.end) {
                    offset.negate();
                }
                float width = this.originalWidth + (float)change;
                Vector3d center = this.originalCenter.add(offset, new Vector3d());
                if (this.session.setWidth(Math.abs(width))) {
                    this.session.setCenter(center);
                }
            }
        }

        @Override
        public double snapChange(double change, @NotNull Snapper context) {
            if (!BoxResizeTool.this.end) {
                change = -change;
            }
            change += (double)this.originalValue;
            change = context.snapPosition(change);
            change -= (double)this.originalValue;
            if (!BoxResizeTool.this.end) {
                change = -change;
            }
            return change;
        }

        @Override
        public void setValue(double value) {
            double change = value - (double)this.originalValue;
            if (!BoxResizeTool.this.end) {
                change = -change;
            }
            this.setChange(change);
        }

        @Override
        public void revert() {
            this.session.revert();
        }

        @Override
        public void commit(@Nullable Component description) {
            this.session.commit(description);
        }

        @Override
        public boolean isValid() {
            return this.session.isValid();
        }

        @Override
        @Nullable
        public Component getStatus() {
            float value = BoxResizeTool.this.axis == Axis.Y ? this.session.getHeight() : this.session.getWidth();
            return Component.text(Util.SCALE_FORMAT.format(value));
        }

        @Override
        @Nullable
        public Component getDescription() {
            return Message.component("easyarmorstands.history.resize-box");
        }

        @Override
        public boolean canSetValue(Player player) {
            return player.hasPermission("easyarmorstands.position");
        }
    }
}

