/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.tool;

import me.m56738.easyarmorstands.api.editor.Snapper;
import me.m56738.easyarmorstands.api.editor.tool.MoveTool;
import me.m56738.easyarmorstands.api.editor.tool.MoveToolSession;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.editor.box.BoundingBoxEditor;
import me.m56738.easyarmorstands.editor.box.BoundingBoxEditorSession;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoxMoveTool
implements MoveTool {
    private final BoundingBoxEditor editor;
    private final ToolContext context;

    public BoxMoveTool(BoundingBoxEditor editor, ToolContext context) {
        this.editor = editor;
        this.context = context;
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.context.position().getPosition();
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.context.rotation().getRotation();
    }

    @Override
    @NotNull
    public MoveToolSession start() {
        return new SessionImpl(this.editor.start());
    }

    @Override
    public boolean canUse(@NotNull Player player) {
        return this.editor.canMove(player);
    }

    private static class SessionImpl
    implements MoveToolSession {
        private final BoundingBoxEditorSession session;
        private final Vector3dc center;
        private final Vector3d offset = new Vector3d();

        public SessionImpl(BoundingBoxEditorSession session) {
            this.session = session;
            this.center = session.getBoundingBox().getCenter(new Vector3d());
        }

        @Override
        public void setChange(@NotNull Vector3dc change) {
            this.offset.set(change);
            this.session.setCenter(this.center.add(change, new Vector3d(this.offset)));
        }

        @Override
        public void snapChange(@NotNull Vector3d change, @NotNull Snapper context) {
            change.add(this.center);
            context.snapPosition(change);
            change.sub(this.center);
        }

        @Override
        @NotNull
        public Vector3dc getPosition() {
            return this.session.getBoundingBox().getCenter(new Vector3d());
        }

        @Override
        public void setPosition(@NotNull Vector3dc position) {
            this.setChange(position.sub(this.center, this.offset));
        }

        @Override
        public void revert() {
            this.session.revert();
        }

        @Override
        public void commit(@Nullable Component description) {
            this.session.commit(description);
        }

        @Override
        public boolean isValid() {
            return this.session.isValid();
        }

        @Override
        @Nullable
        public Component getStatus() {
            return Util.formatOffset(this.offset);
        }

        @Override
        @Nullable
        public Component getDescription() {
            return Message.component("easyarmorstands.history.move-box", Util.formatOffset(this.offset));
        }

        @Override
        public boolean canSetPosition(Player player) {
            return player.hasPermission("easyarmorstands.position");
        }
    }
}

