/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.node;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.EnterContext;
import me.m56738.easyarmorstands.api.editor.context.ExitContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.tool.ScalarToolSession;
import me.m56738.easyarmorstands.api.particle.LineParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.editor.node.ToolNode;
import me.m56738.easyarmorstands.editor.node.ValueNode;
import me.m56738.easyarmorstands.lib.cloud.parser.ArgumentParser;
import me.m56738.easyarmorstands.lib.cloud.parser.standard.DoubleParser;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.util.Cursor3D;
import me.m56738.easyarmorstands.util.EasMath;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public abstract class AxisLineToolNode
extends ToolNode
implements ValueNode<Double> {
    private final Session session;
    private final ScalarToolSession toolSession;
    private final double length;
    private final Vector3dc position;
    private final Quaterniondc rotation;
    private final Axis axis;
    private final Vector3dc direction;
    private final LineParticle particle;
    private final LineParticle cursorLineParticle;
    private final Cursor3D cursor;
    private final Vector3d initialCursor = new Vector3d();
    private final Vector3d temp = new Vector3d();
    private double initialOffset;
    private boolean hasManualInput;

    public AxisLineToolNode(Session session, ScalarToolSession toolSession, Component name, ParticleColor color, double length, Vector3dc position, Quaterniondc rotation, Axis axis) {
        super(session, toolSession, name);
        this.session = session;
        this.toolSession = toolSession;
        this.length = length;
        this.position = new Vector3d(position);
        this.rotation = new Quaterniond(rotation);
        this.axis = axis;
        this.direction = axis.getDirection().rotate(rotation, new Vector3d());
        this.particle = session.particleProvider().createLine();
        this.particle.setColor(color);
        this.cursorLineParticle = session.particleProvider().createLine();
        this.cursor = new Cursor3D(session);
    }

    protected Vector3dc getDefaultCursor() {
        return this.position;
    }

    @Override
    public void onEnter(@NotNull EnterContext context) {
        this.initialCursor.set(context.cursorOrDefault(this::getDefaultCursor));
        this.initialOffset = EasMath.getOffsetAlongLine(this.position, this.direction, this.initialCursor);
        this.cursor.start(context, this.initialCursor);
        double scale = this.session.getScale(this.position);
        this.particle.setRotation(this.rotation);
        this.particle.setAxis(this.axis);
        this.updateParticles(this.initialOffset, scale);
        this.session.addParticle(this.particle);
        this.session.addParticle(this.cursorLineParticle);
        this.hasManualInput = false;
    }

    @Override
    public void onExit(@NotNull ExitContext context) {
        super.onExit(context);
        this.cursor.stop();
        this.session.removeParticle(this.cursorLineParticle);
        this.session.removeParticle(this.particle);
    }

    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        this.cursor.update(context);
        double scale = this.session.getScale(EasMath.getClosestPointOnLine(this.position, this.direction, context.eyeRay().origin(), this.temp));
        if (!this.hasManualInput) {
            double offset = EasMath.getOffsetAlongLine(this.position, this.direction, this.cursor.get());
            double change = this.toolSession.snapChange(this.getChange(offset, this.initialOffset), this.session.snapper());
            this.toolSession.setChange(change);
            this.updateParticles(offset, scale);
        } else {
            this.updateParticleScales(scale);
        }
        super.onUpdate(context);
    }

    private void updateParticles(double offset, double scale) {
        double min = Math.min(0.0, offset) - this.length / 2.0 * scale;
        double max = Math.max(0.0, offset) + this.length / 2.0 * scale;
        this.particle.setCenter(this.position.fma(offset, this.direction, this.temp));
        this.particle.setLength(max - min);
        this.particle.setOffset(min - offset + (max - min) / 2.0);
        this.cursorLineParticle.setFromTo(this.position.fma(offset, this.direction, this.temp), this.cursor.get());
        this.updateParticleScales(scale);
    }

    private void updateParticleScales(double scale) {
        this.particle.setWidth(0.015625 * scale);
        this.cursorLineParticle.setWidth(0.015625 * scale);
    }

    protected abstract double getChange(double var1, double var3);

    @Override
    public Component formatValue(Double value) {
        return Component.text(Util.OFFSET_FORMAT.format(value));
    }

    @Override
    public ArgumentParser<CommandSender, Double> getParser() {
        return new DoubleParser<CommandSender>(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public boolean canSetValue() {
        return this.toolSession.canSetValue(this.session.player());
    }

    @Override
    public void setValue(Double value) {
        this.toolSession.setValue(value);
        this.hasManualInput = true;
        this.session.removeParticle(this.cursorLineParticle);
        this.cursor.stop();
    }
}

