/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.button;

import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.ScaleButton;
import me.m56738.easyarmorstands.api.editor.button.ScaleButtonBuilder;
import me.m56738.easyarmorstands.api.editor.tool.ScaleTool;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.editor.button.ScaleButtonImpl;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.message.Message;
import org.jetbrains.annotations.NotNull;

public class ScaleButtonBuilderImpl
implements ScaleButtonBuilder {
    private final Session session;
    private ScaleTool tool;
    private Component name;
    private ParticleColor color = ParticleColor.AQUA;
    private int priority;

    public ScaleButtonBuilderImpl(Session session) {
        this.session = session;
    }

    @Override
    @NotNull
    public ScaleButtonBuilder setTool(@NotNull ScaleTool tool) {
        this.tool = tool;
        return this;
    }

    @Override
    @NotNull
    public ScaleButtonBuilder setName(@NotNull Component name) {
        this.name = name;
        return this;
    }

    @Override
    @NotNull
    public ScaleButtonBuilder setColor(@NotNull ParticleColor color) {
        this.color = color;
        return this;
    }

    @Override
    @NotNull
    public ScaleButtonBuilder setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    @NotNull
    public ScaleButton build() {
        if (this.tool == null) {
            throw new IllegalStateException("Tool not set");
        }
        Component name = this.name;
        if (name == null) {
            name = Message.component("easyarmorstands.node.scale").color(TextColor.color(this.color));
        }
        return new ScaleButtonImpl(this.session, this.tool, name, this.color, this.priority);
    }
}

