/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.button;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.AxisRotateButton;
import me.m56738.easyarmorstands.api.editor.button.AxisRotateButtonBuilder;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateTool;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.editor.button.AxisRotateButtonImpl;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.message.Message;
import org.jetbrains.annotations.NotNull;

public class AxisRotateButtonBuilderImpl
implements AxisRotateButtonBuilder {
    private final Session session;
    private AxisRotateTool tool;
    private double radius = 1.0;
    private double length = 3.0;
    private ParticleColor color;
    private Component name;

    public AxisRotateButtonBuilderImpl(Session session) {
        this.session = session;
    }

    @Override
    @NotNull
    public AxisRotateButtonBuilder setTool(AxisRotateTool tool) {
        this.tool = tool;
        return this;
    }

    @Override
    @NotNull
    public AxisRotateButtonBuilder setLength(double length) {
        this.length = length;
        return this;
    }

    @Override
    @NotNull
    public AxisRotateButtonBuilder setRadius(double radius) {
        this.radius = radius;
        return this;
    }

    @Override
    @NotNull
    public AxisRotateButtonBuilder setName(@NotNull Component name) {
        this.name = name;
        return this;
    }

    @Override
    @NotNull
    public AxisRotateButtonBuilder setColor(@NotNull ParticleColor color) {
        this.color = color;
        return this;
    }

    @Override
    @NotNull
    public AxisRotateButton build() {
        ParticleColor color;
        if (this.tool == null) {
            throw new IllegalStateException("Tool not set");
        }
        Axis axis = this.tool.getAxis();
        Component name = this.name;
        if (name == null) {
            TextColor textColor = TextColor.color(axis.getColor());
            name = Message.component("easyarmorstands.node.rotate-around-axis", Component.text(axis.getName())).color(textColor);
        }
        if ((color = this.color) == null) {
            color = axis.getColor();
        }
        return new AxisRotateButtonImpl(this.session, this.tool, this.radius, this.length, name, color);
    }
}

